define("workflow-designer/io/ajax/ajax-manager", [
    "jira/ajs/ajax/smart-ajax/web-sudo",
    "workflow-designer/underscore",
    "jquery",
    "workflow-designer/backbone"
], function(
    WebSudo,
    _,
    jQuery,
    Backbone
) {

    function isSaveRequest(options) {
        var method = String(options.method || options.type);
        return _.contains(["post", "put", "delete"], method.toLowerCase());
    }

    /**
     * The base AJAX manager object.
     *
     * @namespace
     */
    return Backbone.Marionette.Controller.extend({
        /**
         * Make an AJAX request.
         *
         * Attaches a CSRF token to the request and handles WebSudo.
         *
         * @param {object} options Options to pass to `jQuery.ajax()`.
         * @param {boolean} [silent=false] when false triggers "sync" event for non-GET request
         * @protected
         */
        _makeRequest: function (options, silent) {
            var deferred = jQuery.Deferred();
            var request;
            var promise;

            options.headers = _.extend({}, options.headers, {
                "X-Atlassian-Token": "no-check"
            });

            request = WebSudo.makeWebSudoRequest(options, {
                cancel: function (e) {
                    // Rejection must be deferred to ensure that the WebSudo
                    // dialog has closed and the original one is restored.
                    _.defer(deferred.reject, undefined, "abort");
                    e.preventDefault();
                }
            });

            request.done(deferred.resolve);
            request.fail(deferred.reject);

            promise = deferred.promise();

            if (!silent && isSaveRequest(options)) {
                this.trigger("sync", promise);
            }

            return promise;
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.IO.AJAX.AJAXManager", null, require("workflow-designer/io/ajax/ajax-manager"));