AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-io","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var B=require("workflow-designer/io/layout-auto-saver");var F=require("workflow-designer/workflow-model");var C=require("workflow-designer/messages");var E=require("workflow-designer/io/ajax/workflow-ajax-manager");var D=require("jquery");var A=require("workflow-designer/test-utilities");module("LayoutAutoSaver",{createLayoutAutoSaver:function(){return new B({window:this.window,workflowModel:this.workflowModel})},setup:function(){this.sandbox=sinon.sandbox.create();this.showErrorMessageStub=this.sandbox.stub(C,"showErrorMessage");this.saveStub=this.sandbox.stub(E,"save");this.saveStub.returns(D.Deferred().resolve());this.window={onbeforeunload:D.noop};this.workflowModel=new F()},teardown:function(){this.sandbox.restore()},triggerLayoutChangedEvent:function(){this.workflowModel.trigger("layoutChanged")}});test("Calls the error handler on failure",function(){A.fakeTimer(function(G){this.createLayoutAutoSaver();this.saveStub.returns(D.Deferred().reject());this.triggerLayoutChangedEvent();G.tick(1100);equal(this.showErrorMessageStub.callCount,1,"The error handler was called");equal(this.saveStub.callCount,1,"_save() was called")},this)});test("Saves when WorkflowModel triggers a layoutChanged event",function(){A.fakeTimer(function(G){this.createLayoutAutoSaver();this.triggerLayoutChangedEvent();G.tick(1100);equal(this.showErrorMessageStub.callCount,0,"The error handler wasn't called");equal(this.saveStub.callCount,1,"_save() was called")},this)});test("Shows an 'unsaved changes' message",function(){A.fakeTimer(function(G){var H;this.createLayoutAutoSaver();this.triggerLayoutChangedEvent();H=this.window.onbeforeunload;ok(D.noop!==H&&_.isFunction(H),"window.onbeforeunload was set");G.tick(1100);equal(D.noop,this.window.onbeforeunload,"The original window.onbeforeunload was restored")},this)});test("The 'unsaved changes' message is maintained through concurrent saves",function(){A.fakeTimer(function(H){var G=D.Deferred();this.createLayoutAutoSaver();this.saveStub.returns(G);this.triggerLayoutChangedEvent();H.tick(1100);equal(this.saveStub.callCount,1,"_save() was called");this.saveStub.returns(D.Deferred().resolve());this.triggerLayoutChangedEvent();G.resolve();ok(D.noop!==this.window.onbeforeunload,"The original window.onbeforeunload was not restored");H.tick(1100);equal(this.saveStub.callCount,2,"_save() was called");equal(D.noop,this.window.onbeforeunload,"The original window.onbeforeunload was restored")},this)});test("The 'unsaved changes' message is not cleared if saving failed",function(){A.fakeTimer(function(H){var G=D.Deferred();this.saveStub.returns(G);this.createLayoutAutoSaver();this.triggerLayoutChangedEvent();H.tick(1100);G.reject();ok(D.noop!==this.window.onbeforeunload,"The original window.onbeforeunload was not restored")},this)});test("Doesn't show an 'unsaved changes' message if it is disabled",function(){A.fakeTimer(function(){B.disableMessage();this.createLayoutAutoSaver();this.triggerLayoutChangedEvent();equal(D.noop,this.window.onbeforeunload,"window.onbeforeunload was not set")},this)});test("destroy() removes the onbeforeunload handler",function(){var G;A.fakeTimer(function(){G=this.createLayoutAutoSaver();this.saveStub.returns(D.Deferred());this.triggerLayoutChangedEvent();G.destroy();equal(D.noop,this.window.onbeforeunload,"The original window.onbeforeunload was restored");G=this.createLayoutAutoSaver();this.window.onbeforeunload=undefined;this.triggerLayoutChangedEvent();G.destroy();equal(undefined,this.window.onbeforeunload,"The original window.onbeforeunload was restored")},this)})});