AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-io",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var ErrorHandler = require("workflow-designer/io/error-handler");

    module("ErrorHandler", {
        getErrorMessage: function (response, status) {
            return ErrorHandler.getErrorMessage(response, status, {
                generic: "Generic",
                notAuthenticated: "Not Authenticated",
                timeout: "Timeout",
                webSudo: "WebSudo"
            });
        },

        setup: function () {
            this.sandbox = sinon.sandbox.create();
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("getErrorMessage() ignores aborted requests", function () {
        ok(!this.getErrorMessage({}, "abort"), "No error message was returned");
    });

    test("getErrorMessage() recognises error responses", function () {
        var errorMessage = "Error!",
            response;

        response = {
            responseText: errorMessage
        };

        _.each([400, 403, 404], function (status) {
            response.status = status;
            equal(this.getErrorMessage(response, null), errorMessage,
                "The correct error message was returned");
        }, this);
    });

    test("getErrorMessage() recognises generic errors", function () {
        equal(this.getErrorMessage({status: 500}, null), "Generic",
            "The correct error message was returned");
    });

    test("getErrorMessage() recognises not authenticated errors", function () {
        var response;

        response = {
            responseText: "Who are you?",
            status: 401
        };

        equal(this.getErrorMessage(response, null), "Not Authenticated",
            "The correct error message was returned");
    });

    test("getErrorMessage() recognises request timeouts", function () {
        equal(this.getErrorMessage({}, "timeout"), "Timeout",
            "The correct error message was returned");
    });

    test("getErrorMessage() recognises serialized ErrorCollections", function () {
        var errorMessage = "Error!",
            response;

        response = {
            responseText: JSON.stringify({
                errorMessages: [errorMessage],
                errors: {}
            })
        };

        _.each([400, 403, 404], function (status) {
            response.status = status;
            equal(this.getErrorMessage(response, null), errorMessage,
                "The correct error message was returned");
        }, this);
    });

    test("getErrorMessage() recognises WebSudo timeouts", function () {
        var response;

        response = {
            responseText: "You need WebSudo, yo.",
            status: 401
        };

        equal(this.getErrorMessage(response, null), "WebSudo",
            "The correct error message was returned");
    });

});
