AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {



    module("WorkflowService", {
        setup: function () {
            this.requireContext = AJS.test.mockableModuleContext();
        }
    });

    test("Test ready callback is invoked correctly if registered BEFORE workflow designer", function () {

        var workflowService = this.requireContext.require("workflow-designer/internal-api/workflow-service");

        var mockWorkflowDesigner = {getWorkflowData: sinon.stub()};

        workflowService.ready(function (workflowDesigner) {
            workflowDesigner.getWorkflowData();
        });

        workflowService.registerWorkflowDesigner(mockWorkflowDesigner);

        ok(mockWorkflowDesigner.getWorkflowData.calledOnce);

    });

    test("Test ready callback is invoked correctly if registered AFTER workflow designer", function () {

        var workflowService = this.requireContext.require("workflow-designer/internal-api/workflow-service");

        var mockWorkflowDesigner = {getWorkflowData: sinon.stub()};

        workflowService.registerWorkflowDesigner(mockWorkflowDesigner);

        workflowService.ready(function (workflowDesigner) {
            workflowDesigner.getWorkflowData();
        });


        ok(mockWorkflowDesigner.getWorkflowData.calledOnce);
    });

    test("Test ready callback doesn't get invoked more than once per designer", function () {

        var workflowService = this.requireContext.require("workflow-designer/internal-api/workflow-service");

        var mockWorkflowDesigner = {getWorkflowData: sinon.stub()};

        workflowService.ready(function (workflowDesigner) {
            workflowDesigner.getWorkflowData();
        });

        workflowService.registerWorkflowDesigner(mockWorkflowDesigner);
        workflowService.registerWorkflowDesigner(mockWorkflowDesigner);
        workflowService.registerWorkflowDesigner(mockWorkflowDesigner);

        ok(mockWorkflowDesigner.getWorkflowData.calledOnce);
    });

    test("Test ready callback get invoked for multiple designers", function () {

        var workflowService = this.requireContext.require("workflow-designer/internal-api/workflow-service");

        var mockWorkflowDesigner1 = {getWorkflowData: sinon.stub()};
        var mockWorkflowDesigner2 = {getWorkflowData: sinon.stub()};

        workflowService.ready(function (workflowDesigner) {
            workflowDesigner.getWorkflowData();
        });

        workflowService.registerWorkflowDesigner(mockWorkflowDesigner1);
        workflowService.registerWorkflowDesigner(mockWorkflowDesigner2);

        ok(mockWorkflowDesigner1.getWorkflowData.calledOnce);
        ok(mockWorkflowDesigner2.getWorkflowData.calledOnce);
    });

});
