AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-internal-api"
], function () {

    var WorkflowAJAXManager = require("workflow-designer/io/ajax/workflow-ajax-manager");
    var WorkflowGlobalTransitionsAJAXManager = require("workflow-designer/io/ajax/workflow-global-transitions-ajax-manager");
    var WorkflowLoopedTransitionsAJAXManager = require("workflow-designer/io/ajax/workflow-looped-transitions-ajax-manager");
    var WorkflowStatusesAJAXManager = require("workflow-designer/io/ajax/workflow-statuses-ajax-manager");
    var WorkflowTransitionsAJAXManager = require("workflow-designer/io/ajax/workflow-transitions-ajax-manager");
    var jQuery = require("jquery");

    module("SaveStatusService", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.context = AJS.test.mockableModuleContext();

            this.context.mock("workflow-designer/io/ajax/workflow-ajax-manager", WorkflowAJAXManager);
            this.context.mock("workflow-designer/io/ajax/workflow-global-transitions-ajax-manager", WorkflowGlobalTransitionsAJAXManager);
            this.context.mock("workflow-designer/io/ajax/workflow-looped-transitions-ajax-manager", WorkflowLoopedTransitionsAJAXManager);
            this.context.mock("workflow-designer/io/ajax/workflow-statuses-ajax-manager", WorkflowStatusesAJAXManager);
            this.context.mock("workflow-designer/io/ajax/workflow-transitions-ajax-manager", WorkflowTransitionsAJAXManager);

            this.SaveStatusService = this.context.require("workflow-designer/internal-api/save-status-service");
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("Should listenTo 'sync' event of particular AJAXManagers", function () {
        this.sandbox.stub(this.SaveStatusService.prototype, "_syncEventHandler");
        var saveStatusService = new this.SaveStatusService();

        [WorkflowAJAXManager, WorkflowGlobalTransitionsAJAXManager, WorkflowLoopedTransitionsAJAXManager,
            WorkflowStatusesAJAXManager, WorkflowTransitionsAJAXManager].forEach(function (manager, idx) {
            manager.trigger("sync", new jQuery.Deferred());
            sinon.assert.callCount(saveStatusService._syncEventHandler, idx + 1);
        });
    });
});
