AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {
    var panelService = require("workflow-designer/internal-api/panel-service");

    module("PanelService", {
        setup: function () {
            panelService.addPanel("location.a", {
                weight: 15,
                template: function (ctx) {
                    return "I am panel Fred with context '" + ctx.projectKey + "'";
                }
            });
            panelService.addPanel("location.a", {
                weight: 10,
                template: function (ctx) {
                    return "I am panel Bob with context '" + ctx.projectKey + "'";
                }
            });

            panelService.addPanel("location.b", {
                weight: 25,
                template: function (ctx) {
                    return "I am panel Larry with context '" + ctx.projectKey + "'";
                }
            });
            panelService.addPanel("location.b", {
                weight: 26,
                template: function (ctx) {
                    return "I am panel Bruce with context '" + ctx.projectKey + "'";
                }
            });

        }
    });

    test("Rendering added panels", function () {
        var renderingResultA = panelService.renderPanels("location.a", {projectKey: "HSP"});
        equal(renderingResultA[0], "I am panel Bob with context 'HSP'");
        equal(renderingResultA[1], "I am panel Fred with context 'HSP'");

        var renderingResultB = panelService.renderPanels("location.b", {projectKey: "MKY"});
        equal(renderingResultB[0], "I am panel Larry with context 'MKY'");
        equal(renderingResultB[1], "I am panel Bruce with context 'MKY'");

        var renderingResultC = panelService.renderPanels("location.c", {projectKey: "MKY"});
        equal(renderingResultC, undefined);
    });

});
