AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-models",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {
    var StatusModel = require("workflow-designer/status-model");
    var TransitionCollection = require("workflow-designer/transition-collection");

    module("TransitionCollection", {

        setup: function () {
            var models = [
                new StatusModel({id: "0", initial: true}),
                new StatusModel({id: "1"}),
                new StatusModel({id: "2"})
            ];

            this.transitions = new TransitionCollection();
            this.transitions.add([
                {id: 0, name: "0->1", source: models[0], target: models[1]},
                {id: 1, name: "1->2", source: models[1], target: models[2]}
            ]);
        }
    });

    test("getInitial()", function () {
        equal(this.transitions.getInitial(), this.transitions.get(0), "It returns the initial transition");
    });

});
