define("workflow-designer/panel-collection", [
    "workflow-designer/panel-model",
    "workflow-designer/backbone"
], function(
    PanelModel,
    Backbone
) {
    /**
     * A collection of {@link JIRA.WorkflowDesigner.PanelModel}s.
     *
     * @class JIRA.WorkflowDesigner.PanelCollection
     * @extends Backbone.Collection
     */
    return Backbone.Collection.extend(
        /** @lends JIRA.WorkflowDesigner.PanelCollection# */
        {
            /**
             * The model class that the collection contains
             *
             * @param {object} attributes
             * @param {object} options
             * @returns {JIRA.WorkflowDesigner.PanelModel}
             */
            model: function (attributes, options) {
                return new PanelModel(attributes, options);
            },
            comparator: "weight"
        });
});

AJS.namespace("JIRA.WorkflowDesigner.PanelCollection", null, require("workflow-designer/panel-collection"));