AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-read-only",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var CanvasModel = require("workflow-designer/canvas-model");
    var WorkflowModel = require("workflow-designer/workflow-model");
    var Analytics = require("workflow-designer/analytics");

    module("CanvasModel", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.workflowModel = new WorkflowModel();
            this.canvasModel = new CanvasModel({}, {
                workflowModel: this.workflowModel
            });
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("Deselects the selected model/view when it is destroyed", function () {
        var transition = this.workflowModel.addTransition({});

        this.canvasModel.set({
            selectedModel: transition,
            selectedView: {}
        });

        transition.destroy();
        ok(!this.canvasModel.has("selectedModel"), "The selectedModel property is cleared");
        ok(!this.canvasModel.has("selectedView"), "The selectedView property is cleared");
    });

    test("selectView()", function () {
        var view = {model: {}};
        this.canvasModel.selectView(view);

        ok(this.canvasModel.get("selectedModel") === view.model, "The WorkflowModel's selectedModel property was set");
        ok(this.canvasModel.get("selectedView") === view, "The WorkflowModel's selectedView property was set");
    });

    test("Selects new statuses", function () {
        var closed = this.workflowModel.addStatus({name: "Closed"}),
            open = this.workflowModel.addStatus({name: "Open"});

        this.workflowModel.trigger("new:status", closed);
        ok(this.canvasModel.get("selectedModel") === closed, "The new status was selected");

        // Existing selections aren't overwritten.
        this.workflowModel.trigger("new:status", open);
        ok(this.canvasModel.get("selectedModel") === closed, "The new status wasn't selected");
    });

    test("Selects new transitions", function () {
        var close = this.workflowModel.addTransition({name: "Close"}),
            open = this.workflowModel.addTransition({name: "Open"});

        this.workflowModel.trigger("new:transition", close);
        ok(this.canvasModel.get("selectedModel") === close, "The new transition was selected");

        // Existing selections aren't overwritten.
        this.workflowModel.trigger("new:transition", open);
        ok(this.canvasModel.get("selectedModel") === close, "The new transition wasn't selected");
    });

    test("Setting the \"showTransitionLabels\" property triggers an analytics event", function () {
        this.sandbox.stub(Analytics, "triggerToggleLabels");

        // Reset these values to the "default" state
        this.canvasModel.set("showTransitionLabels", false);
        Analytics.triggerToggleLabels.reset();

        this.canvasModel.set("showTransitionLabels", true);
        equal(Analytics.triggerToggleLabels.args[0][0], true,
            "An analytics event is triggered when labels are shown");

        this.canvasModel.set("showTransitionLabels", false);
        equal(Analytics.triggerToggleLabels.args[1][0], false,
            "An analytics event is triggered when labels are hidden");
    });

    test("The user's \"show transition labels\" preference defaults to false", function () {
        var canvasModel;

        canvasModel = new CanvasModel({}, {
            workflowModel: this.workflowModel
        });

        strictEqual(canvasModel.get("showTransitionLabels"), false, "The showTransitionLabels property has defaulted to false");
    });

});
