AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer"],function(){var A;var D;var E;var C;var B;var I;var F;var H;var G=require("jquery");module("Application",{setup:function(){this.sandbox=sinon.sandbox.create();this.context=AJS.test.mockableModuleContext();var J=require("workflow-designer/io/ajax/workflow-ajax-manager");this.loadWorkflowStub=this.sandbox.stub(J,"load");this.publishStub=this.sandbox.stub(J,"publish");this.discardStub=this.sandbox.stub(J,"discard");this.mauStub=this.sandbox.stub(J,"triggerMauEventForProject");this.context.mock("workflow-designer/io/ajax/workflow-ajax-manager",J);C=this.context.require("workflow-designer/io/ajax/workflow-ajax-manager");this.context.mock("workflow-designer/browser-support",require("workflow-designer/browser-support"));F=this.context.require("workflow-designer/browser-support");this.context.mock("workflow-designer/io/layout-auto-saver",require("workflow-designer/io/layout-auto-saver"));I=this.context.require("workflow-designer/io/layout-auto-saver");this.context.mock("workflow-designer/templates",require("workflow-designer/templates"));H=this.context.require("workflow-designer/templates");this.context.mock("workflow-designer/messages",require("workflow-designer/messages"));B=this.context.require("workflow-designer/messages");var L=require("workflow-designer/workflow-model");this.workflowModelResetSpy=this.sandbox.spy(L.prototype,"reset");var K=new L();this.context.mock("workflow-designer/workflow-model",sinon.stub().returns(K));E=this.context.require("workflow-designer/workflow-model");D=require("workflow-designer/canvas");this.sandbox.spy(D.prototype,"initialize");this.sandbox.spy(D.prototype,"hideProgressIndicator");this.sandbox.spy(D.prototype,"showProgressIndicator");this.sandbox.spy(D.prototype,"autoFit");this.context.mock("workflow-designer/canvas",D)},teardown:function(){this.sandbox.restore()},prepareApplication:function(){A=this.context.require("workflow-designer/application")},getFixtureEl:function(){return G("<div/>").appendTo("#qunit-fixture").css("height",500)}});test("A global message is shown on error",function(){var K="No!",J=this.sandbox.stub(B,"showErrorMessage");this.prepareApplication();this.loadWorkflowStub.returns(G.Deferred().reject(K));new A({workflowId:"Workflow",element:this.getFixtureEl()});equal(J.callCount,1,"Messages.showErrorMessage was called");deepEqual(J.args[0],[K],"It was passed the correct arguments")});test("A warning is shown in unsupported browsers",function(){var K=this.getFixtureEl(),J=this.sandbox.stub(F,"browserIsSupported").returns(false),L=this.sandbox.spy(H,"browserNotSupportedWarning");this.prepareApplication();new A({element:K});sinon.assert.notCalled(D.prototype.initialize);equal(J.callCount,1,"BrowserSupport.browserIsSupported was called");equal(L.callCount,1,"JIRA.WorkflowDesigner.Templates.browserNotSupportWarning was called");equal(K.find(".aui-message.warning").length,1,"The warning was appended to the application's element")});test("destroy() calls LayoutAutoSaver#destroy",function(){this.prepareApplication();var J=this.sandbox.spy(I.prototype,"destroy");new A({element:this.getFixtureEl()}).destroy();equal(J.callCount,1,"LayoutAutoSaver#destroy was called")});test("destroy() doesn't throw an exception in unsupported browsers",function(){this.prepareApplication();var J;expect(0);this.sandbox.stub(F,"browserIsSupported").returns(false);J=new A({element:this.getFixtureEl()});J.destroy()});test("Passing layout data to the constructor",function(){this.prepareApplication();new A({layoutData:{},element:this.getFixtureEl()});equal(this.workflowModelResetSpy.callCount,1,"The Application's WorkflowModel was reset")});test("Should clean-up SaveStatusService when being destroyed",function(){this.prepareApplication();var L=new A({element:this.getFixtureEl()});var K=L._saveStatusService;this.sandbox.spy(K,"close");var J=this.sandbox.stub(L,"trigger").withArgs("sync");L.destroy();sinon.assert.calledOnce(K.close);sinon.assert.notCalled(J);K.trigger("state:success");sinon.assert.notCalled(J)});test("Should close canvas when being destroyed",function(){this.prepareApplication();var K=new A({element:this.getFixtureEl()});var J=this.sandbox.spy(K._canvas,"close");sinon.assert.notCalled(J);K.destroy();sinon.assert.calledOnce(J)});test("Should pass SaveStatusService to Canvas",function(){this.prepareApplication();var K=new A({element:this.getFixtureEl()});sinon.assert.calledOnce(K._canvas.initialize);var J=K._canvas.initialize.getCall(0).args[0];strictEqual(J.workflowModel,K._workflowModel,"incorrect WorkflowModel");strictEqual(J.saveStatusService,K._saveStatusService,"incorrect SaveStatusService")});test("Should listen on 'state:success' of SaveStatusService and trigger 'sync' event",function(){this.prepareApplication();var L=new A({element:this.getFixtureEl()});var K=L._saveStatusService;var J=this.sandbox.stub(L,"trigger").withArgs("sync");sinon.assert.notCalled(J);K.trigger("state:success");sinon.assert.calledOnce(J);K.trigger("state:success");sinon.assert.calledTwice(J)});test("Should set `updatedDate` to null when `isDraftWithChanges=false` was passed to the constructor",function(){this.prepareApplication();new A({isDraftWithChanges:false,layoutData:{},element:this.getFixtureEl()});sinon.assert.calledOnce(this.workflowModelResetSpy);deepEqual(this.workflowModelResetSpy.args[0],[{updatedDate:null}])});test("Should set `updatedDate` to null when `isDraftWithChanges` was not passed to the constructor",function(){this.prepareApplication();new A({layoutData:{},element:this.getFixtureEl()});sinon.assert.calledOnce(this.workflowModelResetSpy);deepEqual(this.workflowModelResetSpy.args[0],[{updatedDate:null}])});test("Should not change `updatedDate` when `isDraftWithChanges=true` was passed to the constructor",function(){this.prepareApplication();new A({isDraftWithChanges:true,layoutData:{},element:this.getFixtureEl()});sinon.assert.calledOnce(this.workflowModelResetSpy);deepEqual(this.workflowModelResetSpy.args[0],[{}])});test("Supports loading a workflow by ID",function(){var J=G.Deferred();var K=E();this.loadWorkflowStub.returns(J.promise());this.prepareApplication();var L=new A({workflowId:"Workflow",element:this.getFixtureEl()});equal(this.loadWorkflowStub.callCount,1,"WorkflowAJAXManager#load() was called");deepEqual(this.loadWorkflowStub.args[0],["Workflow",false],"It was passed the correct arguments");equal(L._canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");J.resolve({});equal(L._canvas.autoFit.callCount,1,"Canvas#autoFit() was called");equal(L._canvas.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator() was called");equal(this.mauStub.callCount,1,"WorkflowAJAXManager#triggerMauEventForProject() was called");equal(this.workflowModelResetSpy.callCount,1,"WorkflowModel#reset() was called");deepEqual(this.workflowModelResetSpy.args[0],[{updatedDate:null}],"It was passed the correct arguments");ok(K.has("loadedAt"),"WorkflowModel's loadedAt property was set");ok(K.get("loadedAt") instanceof Date,"It is a Date object");ok(new Date()-K.get("loadedAt")<500,"It is the current time")});test("The current step ID, if given, is passed to WorkflowModel",function(){this.prepareApplication();this.workflowModelSpy=E;new A({currentStepId:42,element:this.getFixtureEl()});equal(this.workflowModelSpy.args[0][0].currentStepId,42,"The current step ID was passed to the WorkflowModel constructor")});test('Triggers a "loaded" event after successfully loading a workflow via AJAX',function(){this.prepareApplication();var K,J=G.Deferred(),L=sinon.spy();this.loadWorkflowStub.returns(J.promise());K=new A({workflowId:"Workflow",element:this.getFixtureEl()});K.on("loaded",L);J.resolve({});equal(L.callCount,1,'A "loaded" event was triggered')});test('Triggers a "loaded" event after successfully loading the given workflow data',function(){this.prepareApplication();var J=this.sandbox.spy(A.prototype,"trigger");new A({layoutData:{},element:this.getFixtureEl()});ok(J.calledWithExactly("loaded"),'A "loaded" event was triggered')});test("publishDraft() successfully publishes draft",function(){this.prepareApplication();var N=new A({workflowId:"Workflow",element:this.getFixtureEl()}),L,J=G.Deferred(),M=G.Deferred().resolve(),K=this.sandbox.stub(B,"showErrorMessage"),O=this.sandbox.stub(A.prototype,"_loadWorkflow");this.publishStub.returns(J.promise());O.returns(M);L=N.publishDraft();equal(N._canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(L.state(),"pending","The returned deferred is pending");equal(this.publishStub.callCount,1,"WorkflowAJAXManager#publish() was called");J.resolve();equal(L.state(),"resolved","The returned deferred is resolved on success");equal(N._canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(K.callCount,0,"Messages.showErrorMessage was not called");equal(O.callCount,1,"Workflow designer was reloaded")});test("publishDraft() without reloadDesigner flag successfully publishes draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow",element:this.getFixtureEl()}),L,J=G.Deferred(),K=this.sandbox.stub(B,"showErrorMessage"),N=this.sandbox.stub(A.prototype,"_loadWorkflow");this.publishStub.returns(J.promise());L=M.publishDraft({reloadDesigner:false});equal(M._canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(L.state(),"pending","The returned deferred is pending");equal(this.publishStub.callCount,1,"WorkflowAJAXManager#publish() was called");J.resolve();equal(L.state(),"resolved","The returned deferred is resolved on success");equal(M._canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(K.callCount,0,"Messages.showErrorMessage was not called");equal(N.callCount,0,"Workflow designer was not reloaded")});test("publishDraft() fails publishing draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow",element:this.getFixtureEl()}),L,J=G.Deferred(),K=this.sandbox.stub(B,"showErrorMessage");this.publishStub.returns(J.promise());L=M.publishDraft();equal(L.state(),"pending","The returned deferred is pending");equal(this.publishStub.callCount,1,"WorkflowAJAXManager#publish() was called");equal(M._canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");J.reject("error message");equal(L.state(),"rejected","The returned deferred is rejected on failure");equal(M._canvas.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator() was called");equal(K.callCount,1,"Messages.showErrorMessage was called")});test("discardDraft() successfully discards draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow",element:this.getFixtureEl()}),L,J=G.Deferred(),K=this.sandbox.stub(B,"showErrorMessage"),N=this.sandbox.stub(A.prototype,"_loadWorkflow");this.discardStub.returns(J.promise());N.returns(G.Deferred().resolve());L=M.discardDraft();equal(L.state(),"pending","The returned deferred is pending");equal(M._canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(this.discardStub.callCount,1,"WorkflowAJAXManager#discard() was called");J.resolve();equal(L.state(),"resolved","The returned deferred is resolved on success");equal(M._canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(K.callCount,0,"Messages.showErrorMessage was not called");equal(this.discardStub.callCount,1,"WorkflowAJAXManager#discard() was called");equal(N.callCount,1,"Workflow designer was reloaded")});test("discardDraft() without reloadDesigner flag successfully discards draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow",element:this.getFixtureEl()}),L,J=G.Deferred(),K=this.sandbox.stub(B,"showErrorMessage"),N=this.sandbox.stub(A.prototype,"_loadWorkflow");this.discardStub.returns(J.promise());N.returns(G.Deferred().resolve());L=M.discardDraft({reloadDesigner:false});equal(L.state(),"pending","The returned deferred is pending");equal(M._canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(this.discardStub.callCount,1,"WorkflowAJAXManager#discard() was called");J.resolve();equal(L.state(),"resolved","The returned deferred is resolved on success");equal(M._canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(K.callCount,0,"Messages.showErrorMessage was not called");equal(N.callCount,0,"Workflow designer was not reloaded")});test("discardDraft() fails discarding draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow",element:this.getFixtureEl()}),L,J=G.Deferred(),K=this.sandbox.stub(B,"showErrorMessage");this.discardStub.returns(J.promise());L=M.discardDraft();equal(L.state(),"pending","The returned deferred is pending");equal(M._canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");J.reject("error message");equal(L.state(),"rejected","The returned deferred is rejected on failure");equal(M._canvas.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator() was called");equal(K.callCount,1,"Messages.showErrorMessage was called")})});