AJS.test.require(["jira.webresources:calendar","jira.webresources:calendar-en"],function(){"use strict";var e=require("jira/util/logger"),t=require("jquery"),n=require("jira/libs/calendar");module("Calendar"),module("Calendar#setup",{setup:function(){this.sandbox=sinon.sandbox.create(),this.calFunc=this.sandbox.stub(window,"Calendar",this.fakeCalendar()),this.setupFunc=this.calFunc.setup},teardown:function(){this.sandbox.restore(),delete window.calendar},fakeCalendar:function(){var e=this.sandbox.spy(n);return e.prototype.setRange=this.sandbox.spy(),e.prototype.setDateFormat=this.sandbox.spy(),e.prototype.setDateStatusHandler=this.sandbox.spy(),e.prototype.getDateText=this.sandbox.spy(),e.prototype.parseDate=this.sandbox.spy(),e.prototype.refresh=this.sandbox.spy(),e.prototype.create=this.sandbox.spy(),e.prototype.show=this.sandbox.spy(),e.prototype.showAt=this.sandbox.spy(),e.prototype.showAtElement=this.sandbox.spy(),e}}),test("must pass input field",function(){var t=this.sandbox.spy(e,"log");this.setupFunc(),sinon.assert.calledWith(t,"Calendar.setup:\n  Nothing to setup (no fields found).  Please check your code")}),test("can initialise with DOM element",function(){var e=document.createElement("input");this.setupFunc({inputField:e}),t(e).trigger("click"),sinon.assert.called(this.calFunc),sinon.assert.calledWith(this.calFunc.prototype.showAtElement,e)}),test("can initialise with jQuery element",function(){var e=t("<input>");this.setupFunc({inputField:e}),e.trigger("click"),sinon.assert.called(this.calFunc),sinon.assert.calledWith(this.calFunc.prototype.showAtElement,e[0])}),test("can initialise with an element ID",function(){var e=t("<input id='my-calendar-element'>").appendTo(t("#qunit-fixture"));this.setupFunc({inputField:"my-calendar-element"}),e.trigger("click"),sinon.assert.called(this.calFunc),sinon.assert.calledWith(this.calFunc.prototype.showAtElement,e[0])}),test("can initialise with an element ID that is effectively a CSS selector",function(){var e=t("<input id='my.calendar:element'>").appendTo(t("#qunit-fixture"));this.setupFunc({inputField:"my.calendar:element"}),e.trigger("click"),sinon.assert.called(this.calFunc),sinon.assert.calledWith(this.calFunc.prototype.showAtElement,e[0])}),test("can initialise with an element ID within a context",function(){var e=t("#qunit-fixture"),n=t("<input id='my-calendar-element'>").appendTo(e);this.setupFunc({inputField:"my-calendar-element",context:e}),n.trigger("click"),sinon.assert.called(this.calFunc),sinon.assert.calledWith(this.calFunc.prototype.showAtElement,n[0])}),test("can initialise an element that is not yet attached to the DOM",function(){var n=t("<div></div>"),a=t("<input id='my-calendar-element'>").appendTo(n),i=this.sandbox.spy(e,"log");this.setupFunc({inputField:"my-calendar-element",context:n}),sinon.assert.notCalled(i),a.trigger("click"),sinon.assert.called(this.calFunc),sinon.assert.calledWith(this.calFunc.prototype.showAtElement,a[0])}),module("Calendar's Date.prototype modifications"),test("getWeekNumber using ISO8601 algorithm",function(){for(var e=[[1,1,2005,53],[1,2,2005,53],[1,3,2005,1],[12,22,2008,52],[12,28,2008,52],[12,29,2008,1],[1,4,2009,1],[1,5,2009,2],[1,11,2009,2],[12,21,2009,52],[12,27,2009,52],[12,28,2009,53],[1,3,2010,53],[1,4,2010,1],[1,10,2010,1]],t=0;t<e.length;t++){var n=e[t][0]-1,a=e[t][1],i=e[t][2],s=e[t][3];equal(new Date(i,n,a).getISO8601WeekNumber(),s,"Weeknumber didn't match expectations for "+new Date(i,n,a))}equal(new Date(2006,0,1).getISO8601WeekNumber(),52,"Jan 1 2006 actually is in Week 52 of 2005."),equal(new Date(2006,0,2).getISO8601WeekNumber(),1,"2/1 Week number incorrect."),equal(new Date(2006,0,8).getISO8601WeekNumber(),1,"8/1 Week number incorrect."),equal(new Date(2011,5,6).getISO8601WeekNumber(),23,"June 6, 2011, week number incorrect")}),test("get Week Number 'standard' algorithm i.e. using 1-January as first week",function(){equal(new Date(2005,0,1).getSimpleWeekNumber(),1,"Weeknumber didn't match expectations."),equal(new Date(2005,0,2).getSimpleWeekNumber(),2,"Weeknumber didn't match expectations."),equal(new Date(2005,11,31).getSimpleWeekNumber(),53,"Last day of year should be in week 53."),equal(new Date(2006,0,1).getSimpleWeekNumber(),1,"1/1 Week number incorrect."),equal(new Date(2006,0,2).getSimpleWeekNumber(),1,"2/1 Week number incorrect."),equal(new Date(2006,0,7).getSimpleWeekNumber(),1,"7/1 Week number incorrect."),equal(new Date(2006,0,8).getSimpleWeekNumber(),2,"8/1 Week number incorrect.")}),test("get Week Number 'standard' algorithm when first day of week changes",function(){equal(new Date(2007,0,1).getSimpleWeekNumber(),1,"Jan 1 in week 1 using Sunday"),equal(new Date(2007,0,2).getSimpleWeekNumber(),1,"Jan 2 in week 1 using Sunday"),equal(new Date(2007,0,1).getSimpleWeekNumber(1),1,"Jan 1 in week 1 using Monday as start of week."),equal(new Date(2007,0,2).getSimpleWeekNumber(1),2,"Jan 2 in week 2 using Monday as start of week.")})});