define('jira/viewissue/watchers-voters/views/voters-view', ['require'], function (require) {
    var AuiMessages = require('aui/message');
    var Backbone = require('backbone');
    var _ = require('underscore');
    var jQuery = require('jquery');
    var Deferred = require('jira/jquery/deferred');
    var formatter = require('jira/util/formatter');
    var TEMPLATES = JIRA.Templates.Issue;

    /**
     * View for Voters
     * @class VotersView
     * @extends Backbone.View
     */
    return Backbone.View.extend({
        $empty: undefined,

        initialize: function initialize(options) {
            this.collection = options.collection;
            this.collection.bind("replace reset add remove", this.render, this);
        },

        renderNoWatchers: function renderNoWatchers() {
            if (this.$(".recipients li").length === 0) {
                this.$empty = AuiMessages.info({
                    closeable: false,
                    body: formatter.I18n.getText("voters.novoters")
                });
                this.$("fieldset").append(this.$empty);
            } else if (this.$empty) {
                this.$empty.remove();
            }
        },

        /**
         * Goes to server to get watchers before rendering contents
         *
         * @return {jQuery.Deferred}
         */
        render: function render() {
            var deferred = Deferred();
            this.collection.fetch().done(_.bind(function () {
                this.$el.html(TEMPLATES.usersListReadOnly({ users: this.collection.toJSON() }));
                this.renderNoWatchers();
                deferred.resolve(this.$el);
            }, this));
            return deferred.promise();
        }
    });
});