AJS.test.require(["jira.webresources:mentions-feature"],function(){function e(e,t){return t||(t=e.length),o.getUserNameFromCurrentWord(e,t)}function t(){return JIRA.Mention.prototype._stringPartStartsWith.apply(JIRA.Mention.prototype,arguments)}function a(e){return!!n(JIRA.Templates.mentionsSuggestions({suggestions:[],activity:!1,query:null,isRolesEnabled:e})).find(".aui-list-section-footer").length}var o=require("jira/mention/mention-matcher"),n=require("jquery");module("getUserNameFromCurrentWord - triggers"),test("empty searches",function(){equal(e("@"),"","matching @"),equal(e("[@"),"","matching [@"),equal(e("[~"),"","matching [~"),equal(e("[~@"),"","matching [~@"),equal(e("~@"),"","matching ~@")}),test("non-valid syntaxes do not trigger autocomplete",function(){equal(e("["),null,"matching ["),equal(e("[a"),null,"matching [a")}),test("simple search for 'a'",function(){equal(e("@a"),"a","matching @a"),equal(e("[@a"),"a","matching [@a"),equal(e("[~a"),"a","matching [~a"),equal(e("[~@a"),"a","matching [~@a")}),test("takes the last occurrence of [~ to start the search",function(){equal(e("[~[~["),"[","should only return data after the last [~")}),test("the @ syntax takes precedence over [~ syntax",function(){equal(e("[@~"),"~","matching [@~"),equal(e("[@~a"),"~a","matching [@~a")}),test("the @ syntax does not match if preceded by alpha-numeric characters",function(){equal(e("test@a"),null,"matching test@a"),equal(e("the quick brown fox jumped over the lazy@dog"),null,"there's an alphanumeric character before the @, so shouldn't match"),equal(e("the quick brown fox jumped over the lazy @dog"),"dog","no alphanumeric character before the @, so should search for 'dog'")}),test("the [~ syntax does not match if preceded by alpha-numeric characters",function(){equal(e("test[~a"),null,"matching test[~a"),equal(e("the quick brown fox jumped over the lazy[~dog"),null,"there's an alphanumeric character before the [~, so shouldn't match"),equal(e("the quick brown fox jumped over the lazy [~dog"),"dog","no alphanumeric character before the [~, so should search for 'dog'")}),test("the rest",function(){equal(e("test[@a"),"a","matching test[@a"),equal(e("test[@~a"),"~a","matching test[@~a"),equal(e("test[~@a"),"a","matching test[~@a"),equal(e("a test[@a"),"a","matching a test[@a"),equal(e("a test[@~a"),"~a","matching a test[@~a"),equal(e("a test[~@a"),"a","matching a test[~@a")}),module("getUserNameFromCurrentWord - query"),test("can have multiple words in the query",function(){equal(e("the quick brown fox jumped over the @lazy dog"),"lazy dog","should return 'lazy dog'"),equal(e("the quick brown fox jumped over @the lazy dog"),"the lazy dog","should return 'the lazy dog'")}),test("the query is limited to three words maximum",function(){var t="the quick brown fox @jumped over the lazy dog";equal(e(t,t.length),null,"caret is at end of 5th word after the @, so should return null"),equal(e(t,t.length-4),null,"caret is at end of 4th word after the @, so should return null"),equal(e(t,t.length-7),null,"caret is inside 4th word after the @, so should return null"),equal(e(t,t.length-9),"jumped over the","caret is at end of 3rd word after the @, so should return 'jumped over the'")}),test("the query will return multiple words up to and including any whitespace before the 4th word",function(){var t="the quick brown fox @jumped over the lazy dog";equal(e(t,t.length-8),"jumped over the ","caret is just before the 4th word after the @, so should return everything before it (including the whitespace)"),equal(e(t,t.length-7),null,"caret is just after the 'l' in lazy, which is in the 4th word, so should return null")}),test("trailing whitespace is 'preserved' in the query",function(){equal(e("the quick brown fox jumped over the @lazy dog  "),"lazy dog  ","should keep the space after 'dog'")}),test("infix whitespace is preserved in the query",function(){equal(e("jumped over the @lazy   dog"),"lazy   dog","should keep the three spaces between 'lazy' and 'dog'"),equal(e("jumped over the @lazy \t\t  dog"),"lazy \t\t  dog","keeps everything between 'lazy' and 'dog'")}),test("carriage return and newline break the query",function(){var t="jumped over the @lazy\ndog";equal(e(t,t.length),null,"when the user's caret is on the next line, it returns false"),equal(e(t,t.length-3),null,"when the user's caret is just after the new line, it returns false"),equal(e(t,t.length-4),"lazy","when the user's caret is just before the new line (i.e, just after 'lazy'), it will return 'lazy'")}),module("Mention#_stringPartStartsWith - single word"),test("strings do not start with empty string",function(){ok(!t("something",""),"empty string shouldn't be considered the start of a string")}),test("string starts with",function(){ok(t("admin","a"),"'admin' starts with 'a'"),ok(t("admin","admin"),"identity check -- 'admin' starts with itself"),ok(!t("admin","n"),"'admin' does not start with 'n'"),ok(!t("admin","administrator"),"'admin' does not start with 'administrator'")}),test("is (alpha-numeric) case-insensitive",function(){ok(t("admin","ADM")),ok(t("admin","Adm")),ok(t("Admin","adm")),ok(t("aDmIn","adm")),ok(t("ADMIN","adm"))}),test("string can not start with whitespace",function(){ok(!t(" something"," "),"will not match starting whitespace"),ok(!t(" something"," s"),"will not match literal ' s'"),ok(!t(" something","  "),"string does not start with two spaces")}),test("matches start at first non-whitespace word boundary",function(){ok(t(" something","s"),"ignores whitespace when doing startsWith match")}),test("doesn't treat regex characters specially",function(){ok(t("$AUD","$"),"should match literal '$' and not treat it as end of regex"),ok(t("$.fn.ready","$."),"should match the literal string '$.'"),ok(!t("$$$","$."),"should match literal string '$.' and not use period as any character")}),test("no errors when ill-formed regex",function(){ok(t("[Administrator]","["))}),test("no errors with special HTML characters",function(){ok(t("<strong><em>awesome</em></strong>","<strong><em>a")),ok(t("<script>alert(document.cookie)<\/script>","<script>alert("),"should start with literal html")}),module("Mention#_stringPartStartsWith - multiple words"),test("finds against multiple words",function(){ok(t("the quick brown fox jumps over the lazy dog","b"),"finds startsWith match in the third word."),ok(t("the quick brown fox jumps over the lazy dog","d"),"finds startsWith match in last word.")}),test("words are seperated by any kind of whitespace",function(){var e="  the       quick @brown  .fox (jum-ped o'ver the,lazy  \"dog   ";ok(t(e,"t"),"should match 'the' at the start of the sentence, preceded by two spaces"),ok(t(e,"q"),"should match 'quick' which is preceded by several spaces"),ok(t(e,"b"),"should match 'brown' which is preceded by an @ symbol"),ok(t(e,"f"),"should match 'fox' which is preceded by a period"),ok(t(e,"p"),"should match 'ped' which is preceded by a dash"),ok(t(e,"d"),"should match 'dog' which is preceded by a double-quote"),ok(t(e,"l"),"should match 'lazy' which is preceded by a comma"),ok(t(e,"t"),"should match 'the' which is preceded by a single-quote"),ok(t(e,"j"),"should match 'jum' which is preceded by an open bracket")}),test("does not find words starting with whitespace",function(){ok(!t("the quick brown fox jumps over the lazy dog"," quick")," the word 'quick' should not start with a space")}),test("does not find prefixes that don't exist in the sentence",function(){ok(!t("the quick brown fox jumps over the lazy dog","z"),"z does not occur at the start of a word"),ok(!t("the quick brown fox jumps over the lazy dog","azy"),"azy does not occur at the start of a word")}),test("multi-word prefixes match at start of sentence",function(){ok(t("the quick brown fox jumps over the lazy dog","the q")),ok(t("the quick brown fox jumps over the lazy dog","the quick")),ok(t("the quick brown fox jumps over the lazy dog","the quick brown fox jumps over the lazy dog"))}),test("multi-word prefixes match in middle of sentence",function(){ok(t("the quick brown fox jumps over the lazy dog","the l")),ok(t("the quick brown fox jumps over the lazy dog","the lazy")),ok(t("the quick brown fox jumps over the lazy dog","lazy dog"))}),test("single-word prefixes can include odd non-alphanumeric characters",function(){var e="�dmin <A New Beginning>";ok(t(e,"�dm")),ok(t(e,"�dmin <")),ok(t(e,"�dmin <A New B")),ok(t(e,"<A")),ok(t(e,"Beginning>"))}),test("multi-word prefixes do not match 'logical' nested sentences",function(){ok(!t("�dmin <A New Beginning>","A New")),ok(t("�dmin <A New Beginning>","<A New")),ok(t("�dmin <A New Beginning>","New Begin"))}),module("Mention - role help text"),test("help text should be available when roles is enabled",function(){ok(a(!0))}),test("help text should not be available when roles is not enabled",function(){ok(!a(!1))}),module("Mention#_indexOfFirstMatch"),test("_indexOfFirstMatch",function(){var e=JIRA.Mention.prototype._indexOfFirstMatch;equal(e("Mike Cannon-Brooks","Br"),12),equal(e("Mike Cannon-Brooks","Bre"),-1),equal(e("Mike Cannon-Brooks","Mi"),0),equal(e("Mike Cannon-Brooks","Cann"),5),equal(e("Mike Cannon-Brooks","Cannon-Brooks"),5),equal(e("James O'Brian","Br"),8),equal(e("James O'Brian","O'Br"),6),equal(e("cat@hat.com","ca"),0),equal(e("cat@hat.com","ha"),4),equal(e("cat@hat.com","at"),-1),equal(e("cat@hat.com","co"),8)})});