AJS.test.require(["jira.webresources:messages"],function(){"use strict";var s=require("jira/data/session-storage");module("JIRA Flags",{setup:function(){this.flagElement=document.createElement("div"),this.auiFlagStub=sinon.stub().returns(this.flagElement),this.claimStub=sinon.stub(),this.claimStub.returns(void 0),this.contextPathStub=sinon.stub(),this.contextPathStub.returns("/context-path"),this.sandbox=sinon.sandbox.create({useFakeServer:!0,useFakeTimers:!0}),this.server=this.sandbox.server,this.server.respondWith([204,"",""]);var e=AJS.test.mockableModuleContext();e.mock("aui/flag",this.auiFlagStub),e.mock("wrm/context-path",this.contextPathStub),e.mock("wrm/data",{claim:this.claimStub}),this.flag=e.require("jira/flag"),this.flagShown=function(s,e,t,i){var a=this.auiFlagStub.lastCall.args[0];i=i||{},i.type=s,i.title=e,i.body=t;for(var l in i)i.hasOwnProperty(l)&&equal(a[l],i[l],'correct value of "'+l+'" in options argument')},this.setSessionFlags=function(e){e&&e.length?s.setItem("dismissedFlags",JSON.stringify(e)):s.removeItem("dismissedFlags")},this.getSessionFlags=function(){return JSON.parse(s.getItem("dismissedFlags"))||[]},this.closeFlag=function(){this.flagElement.dispatchEvent(new CustomEvent("aui-flag-close",{bubbles:!0}))},this.dismissFlag=function(){this.flagElement.dismiss()},this.setSessionFlags(null)},teardown:function(){this.server.respond(),this.sandbox.clock.tick(1e4),this.sandbox.restore(),this.setSessionFlags(null)}}),test("Calls aui.flag & sets correct defaults",function(){this.flag.showMsg("Title","Body"),this.flagShown("info","Title","Body")}),test("Success message defaults to auto-close",function(){this.flag.showSuccessMsg("Title","Body"),this.flagShown("success","Title","Body",{close:"auto"}),this.flag.showMsg("Title","Body",{type:"success"}),this.flagShown("success","Title","Body",{close:"auto"})}),test("Preserves explicitly-set close mode for success method",function(){this.flag.showSuccessMsg("Title","Body",{close:"never"}),this.flagShown("success","Title","Body",{close:"never"}),this.flag.showMsg("Title","Body",{type:"success",close:"never"}),this.flagShown("success","Title","Body",{close:"never"})}),test("Uses Info, Success, Warning & Error types",function(){var s="Title",e="Body";this.flag.showInfoMsg(s,e),this.flagShown("info",s,e),this.flag.showWarningMsg(s,e),this.flagShown("warning",s,e),this.flag.showErrorMsg(s,e),this.flagShown("error",s,e),this.flag.showMsg(s,e,{type:"success"}),this.flagShown("success",s,e)}),test("Does not show a dismissed flag",function(){this.claimStub.returns({dismissed:["i.was.dismissed"]}),this.flag.showMsg("Title","Body",{dismissalKey:"i.was.dismissed"}),sinon.assert.notCalled(this.auiFlagStub)}),test("Does not show a dismissed flag from earlier page load",function(){this.claimStub.returns(void 0),this.setSessionFlags(["i.was.dismissed"]),this.flag.showMsg("Title","Body",{dismissalKey:"i.was.dismissed"}),sinon.assert.notCalled(this.auiFlagStub)}),test("PUTs a dismissal to the appropriate URL on close",function(){this.flag.showMsg("Title","Body",{dismissalKey:"was i dismissed?"}),this.flagElement.dispatchEvent(new CustomEvent("aui-flag-close",{bubbles:!0})),equal(this.server.requests.length,1,"One request was made"),equal(this.server.requests[0].method,"PUT","The dismissal request was PUT"),equal(this.server.requests[0].url,"/context-path/rest/flags/1.0/flags/was%20i%20dismissed%3F/dismiss")});var e=function(s){this.flag.showMsg("Title","Body",{dismissalKey:"key"}),deepEqual(this.getSessionFlags(),[],"No flags on load."),s(),deepEqual(this.getSessionFlags(),["key"],"Flag added to the session during the load."),equal(this.server.requests.length,1,"One request was made"),this.server.requests[0].respond(204,{},null),deepEqual(this.getSessionFlags(),[],"Flag removed from the session after response.")};test("Dismissal removes session key on success",function(){e.call(this,this.dismissFlag.bind(this))}),test("Close removes session key on success",function(){e.call(this,this.closeFlag.bind(this))});var t=function(s){this.flag.showMsg("Title","Body",{dismissalKey:"key"}),deepEqual(this.getSessionFlags(),[],"No flags on load."),s(),deepEqual(this.getSessionFlags(),["key"],"Flag added to the session during the load."),equal(this.server.requests.length,1,"One request was made"),this.server.requests[0].respond(500,{},null),deepEqual(this.getSessionFlags(),["key"],"Flag kept on error")};test("Dismissal leaves session key on error",function(){t.call(this,this.dismissFlag.bind(this))}),test("Close leaves session key on error",function(){t.call(this,this.closeFlag.bind(this))}),test("Explicit dismiss triggers rest call",function(){this.flag.showMsg("Title","Body",{dismissalKey:"explicitly.dismissed"}).dismiss(),equal(this.server.requests.length,1,"One request was made"),equal(this.server.requests[0].method,"PUT","The dismissal request was PUT"),equal(this.server.requests[0].url,"/context-path/rest/flags/1.0/flags/explicitly.dismissed/dismiss")}),test("Does not store dismissal of a flag without a key",function(){this.flag.showMsg("Title","Body"),this.flagElement.dispatchEvent(new CustomEvent("aui-flag-close",{bubbles:!0})),equal(this.server.requests.length,0,"No requests were made.")}),test("Explicit dismiss does nothing on flag without a key",function(){this.flag.showMsg("Title","Body").dismiss(),equal(this.server.requests.length,0,"No requests were made.")}),test("Does not show a flag that was just dismissed",function(){this.flag.showMsg("Title","Body",{dismissalKey:"just.dismissed"}),this.flagElement.dispatchEvent(new CustomEvent("aui-flag-close",{bubbles:!0})),this.flag.showMsg("Title","Body",{dismissalKey:"just.dismissed"}),sinon.assert.calledOnce(this.auiFlagStub)}),module("JIRA Flags with DOM rendering",{setup:function(){this.jiraFlag=require("jira/flag")}}),test("A message with a title should have the respective element",function(){var s=AJS.$(this.jiraFlag.showMsg("This is the title","This is the body message"));strictEqual(s.find(".title").size(),1,"Title element should be present")}),test("A message without a title should not have an empty title element",function(){var s=AJS.$(this.jiraFlag.showMsg("","This is another body message"));strictEqual(s.find(".title").size(),0,"No title element should be present")})});