/**
 * Binds single issue picker to the project picker and issue type picker.
 * Used on bulk move page.
 * Issue task that is a subtask triggers the issue container to show up, issue tasks that are not subtasks triggers issue container to hide.
 * Project picker affects the data send by ajax - it restricts the issue picker's responses to be returned from specified project only.
 * The JS consumes JSON data generated by WRM containing all subtask types from this jira instance. The WRM data key is "jira.webresources:jira-bulk-edit.subtaskIds"
 */
(function () {
    var $ = require('jquery');

    var SingleIssuePickerToProjectAndIssueTypeBinder = function SingleIssuePickerToProjectAndIssueTypeBinder(options) {
        if (typeof options.issuePickerSelect !== 'undefined' && typeof options.issuePickerSelect.issuePicker !== 'undefined') {
            this.issuePickerSelect = options.issuePickerSelect;
            this.issuePicker = this.issuePickerSelect.issuePicker;
            this.parentContainerSelector = options.parentContainerSelector;
            this.subtaskIds = options.subtaskIds;

            var issuePickerSelect = this.issuePickerSelect;
            var issuePicker = this.issuePicker;
            var subtaskIds = this.subtaskIds;

            var projectInput = $(this.issuePickerSelect).closest(this.parentContainerSelector).find('input.project-field');
            var issueTypeInput = $(this.issuePickerSelect).closest(this.parentContainerSelector).find('input.issuetype-field');

            if (projectInput.length === 1) {
                //clear issuePicker selection because we should pick issue from new project
                projectInput.change(function () {
                    issuePicker.clear();
                    issuePicker.setCurrentProjectId(projectInput.val());
                });
            }

            if (issueTypeInput.length === 1) {
                // get issue type and bind on its change.
                issueTypeInput.change(function () {
                    //if new issue type is subtask then hide issue picker.
                    var issuePickerContainer = $(issuePickerSelect).closest('tr');
                    var subtask = subtaskIds.indexOf(issueTypeInput.val()) !== -1;
                    if (subtask === true) {
                        issuePickerContainer.show();
                        issuePicker.setCurrentProjectId(projectInput.val());
                    } else {
                        issuePickerContainer.hide();
                    }
                });
                issueTypeInput.change();
            }
        }
        $(issuePickerSelect).addClass("bound-to-project-issuetype");
    };

    //obtain list of subtask ids
    var subtaskIds = WRM.data.claim('jira.webresources:jira-bulk-edit.subtaskIds') || [];

    function initIssuePicker() {
        var parentContainerSelector = '.be-project-type-issue';
        $(parentContainerSelector + ' .aui-field-singleissuepicker').each(function () {
            new SingleIssuePickerToProjectAndIssueTypeBinder({
                issuePickerSelect: this,
                parentContainerSelector: parentContainerSelector,
                subtaskIds: subtaskIds
            });
        });
    }

    $(function initSingleIssuePickersLinkToProjectAndIssueType() {
        initIssuePicker();
    });
})();