AJS.test.require(["jira.webresources:application-roles-init"],function(){"use strict";function e(e){e()}var t=require("underscore"),r=require("jquery"),o=require("backbone"),a=require("marionette"),s=require("wrm/context-path"),i=s();e(function(){var e=function(){return t.extend({},o.Events)},s=function(){return t.toArray(arguments).join(",")},n=function(e){this.options=e,this.items=[]};t.extend(n.prototype,{addItem:function(e){this.items.push(e)},assertDescriptor:function(e,r){equal(this.options.weight,0,"Correct Weight"),equal(this.items.length,r.length,"There should be "+r.length+"items.");for(var o=0;o<this.items.length;o++)this.items[o].assertDescriptor(r[o]);if(e===r.length)ok(t.isUndefined(this.options.label),"No label specified");else{var a=s("application.access.configuration.groups.partial",r.length,e);equal(this.options.label,a,"Label indicating partial results.")}}});var l=function(e){this.options=e};t.extend(l.prototype,{assertDescriptor:function(e){equal(this.options.value,e,"Value should be "+e),equal(this.options.value,e,"Label should be "+e),equal(this.options.html,e,"Label should be "+e),equal(this.options.highlighted,!0,"Item should be highlighted.")}});var u=function(e){this.options=e};t.extend(u.prototype,{clear:sinon.mock()});var p=function(){this.element=r("#qunit-fixture")};t.extend(p.prototype,{select:function(){return this.element.find("select.ss-group-picker")},val:function(e){var t=this.select();0===t.find("option[value='"+e+"']").length&&r("<option>").attr("value",e).text(e).appendTo(t).prop("selected",!0),t.trigger("selected")},loadingVisible:function(){return this.element.find(".loading.icon").length>0}});var d=function(e,r){return{total:e,groups:t.map(r,function(e){return{name:e,html:e}})}},h=function(e,t,r){equal(e.length,1,"There is only one element."),ok(e[0]instanceof n,"The element is a GroupDescriptor"),e[0].assertDescriptor(t,r)};module("Group Selector Tests",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.context.mock("jira/ajs/select/single-select",u),this.context.mock("jira/ajs/list/group-descriptor",n),this.context.mock("jira/ajs/list/item-descriptor",l),this.parser=new p,this.region=new a.Region({el:"#qunit-fixture"}),this.format=AJS.format,AJS.format=s},teardown:function(){AJS.format=this.format}}),test("Constructs single select correctly",function(){var e=this.context.require("jira/admin/application/grouppicker"),t=new e({});this.region.show(t);var r=t.select,o=r.options;equal(o.itemAttrDisplayed,"label","Displaying the label."),equal(o.showDropdownButton,!0,"Showing the dropdown."),ok(o.element.index(this.parser.select())>=0,"Element is the select list.");var a=o.ajaxOptions;deepEqual(a.data("query"),{query:"query"},"Generate correct AJAX GET parameters."),equal(a.url,i+"/rest/api/2/groups/picker","Calls the right REST resource."),equal(a.query,!0,"Queries the server on each keystroke.")});var c=function(e){var t=this.context.require("jira/admin/application/grouppicker"),r=new t;this.region.show(r);var o=r.select.options.ajaxOptions.formatResponse;e.call(this,o,r)};test("formatResponse parses AJAX full response correctly",function(){c.call(this,function(e){var t=e(d(2,["jira-users","jira-developers"]));h(t,2,["jira-users","jira-developers"])})}),test("formatResponse parses partial AJAX response correctly",function(){c.call(this,function(e){var t=e(d(5,["jira-users","jira-developers"]));h(t,5,["jira-users","jira-developers"])})}),test("formatResponse excludes groups",function(){c.call(this,function(e,t){t.excludeGroups("jira-users");var r=e(d(2,["jira-users","jira-developers"]));h(r,1,["jira-developers"])})}),test("formatResponse includes groups",function(){c.call(this,function(e,t){t.excludeGroups("jira-users"),t.includeGroups("jira-users","jira-administrators");var r=e(d(2,["jira-users","jira-developers"]));h(r,2,["jira-users","jira-developers"])})}),test("formatResponse excludes groups partial",function(){c.call(this,function(e,t){t.excludeGroups("jira-users");var r=e(d(5,["jira-users","jira-developers"]));h(r,4,["jira-developers"])})}),test("Updating single select triggers selectGroup event on bus",function(){var t=this.context.require("jira/admin/application/grouppicker"),r=new e,o=new t({bus:r});this.region.show(o);var a=this.spy();r.on("selectGroup",a),this.parser.val("jira-users"),ok(a.calledWith("jira-users"),"'selectGroup' Event triggered with right group."),ok(o.select.clear.calledOnce,"Group selection cleared after event.")}),asyncTest("test loading indicator shows and hides",function(e){var t=this.context.require("jira/admin/application/grouppicker"),r=new t;this.region.show(r);var o=this;r.showLoading(),window.setTimeout(function(){e.ok(o.parser.loadingVisible(),"Loading indicator should be visible after 100ms."),r.hideLoading(),e.ok(!o.parser.loadingVisible(),"Loading indicator should be hidden."),start()},150)})}),e(function(){var e=a.ItemView.extend({initialize:function(){this.exclude=[],this.loading=0},excludeGroups:function(){this.exclude=t.union(this.exclude,t.toArray(arguments))},includeGroups:function(){this.exclude=t.difference(this.exclude,t.toArray(arguments))},template:function(e){return r("<input>").data("view",e.view)},ui:{input:"input"},events:{"newGroup input":"_toAdd"},_toAdd:function(){this.options.bus.trigger("selectGroup",this.ui.input.val())},serializeData:function(){return{view:this}},showLoading:function(){return this.loading++,this},hideLoading:function(){return this.loading--,this},isLoading:function(){return this.loading>0}}),o=function(){this.element=r("#qunit-fixture")};t.extend(o.prototype,{name:function(){return this.element.find("h3").text()},groups:function(){var e=this;return this.element.find("span.application-role-name-group-name").map(function(){return e._toName(r(this))}).get()},groupsDetail:function(){var e=this;return this.element.find("span.application-role-name-group-name").map(function(){return{name:e._toName(r(this)),userCount:e._toUserCount(r(this))}}).get()},getGroupDetail:function(e){return t.findWhere(this.groupsDetail(),{name:e})},getDefaults:function(){var e=this;return this.element.find(".application-role-default input:checked").map(function(){return e._toName(r(this))}).get()},isDefaultApplication:function(){return"common.words.default"===this.element.find(".default-app-lozenge").text()},groupsWithEditableDefault:function(){var e=this;return this.element.find(".application-role-default input:enabled").map(function(){return e._toName(r(this))}).get()},groupDefaultWarningPopupVisible:function(e){var t="#group-reuse-roleid-"+e.cid+"-default-warning",o=r(t);if(!o.length)throw"Could not find default warning popup";return"false"===o.attr("aria-hidden")},groupAddWarningPopupVisible:function(e){var t="#group-reuse-roleid-"+e.cid+"-add-warning",o=r(t);if(!o.length)throw"Could not find group warning popup";return"false"===o.attr("aria-hidden")},deleteable:function(){var e=this;return this.element.find("a.application-role-remove").map(function(){return e._toName(r(this))}).get()},addGroup:function(e){return this.element.find(".application-role-selector-container input").val(e).trigger("newGroup"),this},removeGroup:function(e){var t=this._toRow(e).find("a.application-role-remove");if(!t.length)throw"Not allowed to delete group '"+e+"'.";return t.click(),this},setDefault:function(e){var t=this._getDefaultCheckbox(e);if(t.is(":checked"))throw"Group '"+e+"' is already default.";return t.click(),this},unsetDefault:function(e){var t=this._getDefaultCheckbox(e);if(!t.is(":checked"))throw"Group '"+e+"' is not currently a default.";return t.change(),t.click(),this},_toRow:function(e){var t=this,o=this.element.find(".application-role-name-group-name").filter(function(){return t._toName(r(this))===e});if(o.length)return o.closest("tr");throw"Unable to find group '"+e+"'."},_toName:function(e){if(e.hasClass(".application-role-name-group-name"))return e.text();var t=e.closest("tr").find(".application-role-name-group-name");return t.length?t.text():null},_toUserCount:function(e){var t=e.closest("tr").find(".application-role-name-group-size");return t.length?parseInt(t.attr("data-value")):null},emptyMessageShowing:function(){return!!this.element.find(".application-role-empty").length},noDefaultGroupWarningShowing:function(){return this.element.find(".application-role-without-default-group").length>0},getExcludedGroups:function(){return this._getGroupSelector().exclude},isLoading:function(){return this._getGroupSelector().isLoading()},_getGroupSelector:function(){return this.element.find(".application-role-selector-container input").data("view")},_getDefaultCheckbox:function(e){var t=this._toRow(e).find(".application-role-default input");if(!t.length)throw"Unable to find default checkbox for group '"+e+"'.";return t},defined:function(){return 0===this.element.find("#application-licensed-not-installed").length}});var s=function(){};t.extend(s.prototype,{getGroupDetails:function(e){return r.Deferred().resolve({name:e,users:{size:1}})}}),module("Role Editor Tests",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.context.mock("jira/admin/application/grouppicker",e),this.context.mock("aui/inline-dialog2",{}),this.context.mock("jira/admin/application/application-role-labels",{}),this.parser=new o,this.region=new a.Region({el:"#qunit-fixture"})}}),test("Renders correct view with no defaults",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"]},IO:new s});this.region.show(t.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two","three"],"The groups are rendered correctly."),deepEqual(this.parser.deleteable(),["one","two","three"],"Should be able to delete all groups."),deepEqual(this.parser.groupsWithEditableDefault(),["one","two","three"],"Should be able to set the default of all groups."),deepEqual(this.parser.getExcludedGroups(),["one","two","three"],"Not able to select the current groups."),deepEqual(this.parser.getDefaults(),[],"No default rendered")}),test("Renders correct view with application marked as default",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=new e({data:{key:"roleid",name:"RoleId",groups:["one"],selectedByDefault:!0},IO:new s});this.region.show(t.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),ok(this.parser.isDefaultApplication(),"Rendered application is marked as default")}),test("Renders correct view with one default",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"],defaultGroups:["two"]},IO:new s});this.region.show(t.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two","three"],"The groups are rendered correctly."),deepEqual(this.parser.deleteable(),["one","three"],"Able to delete non default groups."),deepEqual(this.parser.getExcludedGroups(),["one","two","three"],"Not able to select the current groups."),deepEqual(this.parser.groupsWithEditableDefault(),["one","three"],"Should be able to set the default of non-default groups."),deepEqual(this.parser.getDefaults(),["two"],"Default correctly rendered.")}),test("Renders correct view with multiple defaults",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"],defaultGroups:["two","three"]},IO:new s});this.region.show(t.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two","three"],"The groups are rendered correctly."),deepEqual(this.parser.deleteable(),["one","two","three"],"Able to delete non-default groups."),deepEqual(this.parser.getExcludedGroups(),["one","two","three"],"Not able to select the current groups."),deepEqual(this.parser.groupsWithEditableDefault(),["one","two","three"],"Should be able to edit all groups."),deepEqual(this.parser.getDefaults(),["two","three"],"Default correctly rendered.")}),test("Renders correct view with only one default",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=new e({data:{key:"roleid",name:"RoleId",groups:["one"],defaultGroups:["one"]},IO:new s});this.region.show(t.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one"],"The groups are rendered correctly."),deepEqual(this.parser.deleteable(),[],"Nothing is deletable."),deepEqual(this.parser.getExcludedGroups(),["one"],"Not able to select the current groups."),deepEqual(this.parser.groupsWithEditableDefault(),[],"No groups should be editable."),deepEqual(this.parser.getDefaults(),["one"],"Default correctly rendered.")}),test("Add group correctly adds group to the UI with one non-default group",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one"]},setRole:o,IO:new s});this.region.show(a.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one"],"The groups are rendered correctly."),deepEqual(this.parser.getExcludedGroups(),["one"],"Not able to select the current groups."),deepEqual(this.parser.getDefaults(),[],"No default rendered"),deepEqual(this.parser.deleteable(),[],"Should not be able to delete last group."),deepEqual(this.parser.groupsWithEditableDefault(),["one"],"The group should be editable to allow default to be set."),this.parser.addGroup("three"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","three"],"New group correctly rendered."),deepEqual(this.parser.getExcludedGroups(),["one","three"],"Not able to select the new groups."),deepEqual(this.parser.getDefaults(),[],"Still no defaults unless the user explicitly sets it."),deepEqual(this.parser.deleteable(),["one","three"],"Both groups should be deletable."),deepEqual(this.parser.groupsWithEditableDefault(),["one","three"],"Should be able to edit both groups."),ok(o.calledWith(["one","three"],[]),"Change persisted to the server.")}),test("Add group correctly adds group to the UI with multiple non-default groups",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two"]},setRole:o,IO:new s});this.region.show(a.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two"],"The groups are rendered correctly."),deepEqual(this.parser.getExcludedGroups(),["one","two"],"Not able to select the current groups."),deepEqual(this.parser.getDefaults(),[],"No default rendered"),deepEqual(this.parser.deleteable(),["one","two"],"Can delete groups as there are multiple."),deepEqual(this.parser.groupsWithEditableDefault(),["one","two"],"Should be able to edit both groups."),this.parser.addGroup("three"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two","three"],"New group correctly rendered."),deepEqual(this.parser.getExcludedGroups(),["one","two","three"],"Not able to select the new groups."),deepEqual(this.parser.getDefaults(),[],"Still no defaults unless the user explicitly sets it."),deepEqual(this.parser.deleteable(),["one","two","three"],"All groups should be deletable."),deepEqual(this.parser.groupsWithEditableDefault(),["one","two","three"],"Should be able to edit all groups."),ok(o.calledWith(["one","two","three"],[]),"Change persisted to the server.")}),test("Add group correctly adds group to the UI with one default",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two"],defaultGroups:["two"]},setRole:o,IO:new s});this.region.show(a.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two"],"The groups are rendered correctly."),deepEqual(this.parser.getExcludedGroups(),["one","two"],"Not able to select initial groups."),deepEqual(this.parser.deleteable(),["one"],"Able to delete non default groups."),deepEqual(this.parser.getDefaults(),["two"],"Default rendered."),deepEqual(this.parser.groupsWithEditableDefault(),["one"],"Should be able to edit non-default."),this.parser.addGroup("three"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two","three"],"New group correctly rendered."),deepEqual(this.parser.getExcludedGroups(),["one","two","three"],"Not able to select the new groups."),deepEqual(this.parser.deleteable(),["one","three"],"New group should be deletable."),deepEqual(this.parser.getDefaults(),["two"],"Default rendered."),deepEqual(this.parser.groupsWithEditableDefault(),["one","three"],"Should be able to edit non-defaults."),ok(o.calledWith(["one","two","three"],["two"]),"Change persisted to the server.")}),test("Add group correctly adds group to the UI with multiple defaults",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two"],defaultGroups:["one","two"]},setRole:o,IO:new s});this.region.show(a.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two"],"The groups are rendered correctly."),deepEqual(this.parser.getExcludedGroups(),["one","two"],"Not able to select initial groups."),deepEqual(this.parser.deleteable(),["one","two"],"Able to delete groups as there are multiple."),deepEqual(this.parser.getDefaults(),["one","two"],"Default rendereds."),deepEqual(this.parser.groupsWithEditableDefault(),["one","two"],"Should be able to edit defaults as there are many."),this.parser.addGroup("three"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two","three"],"New group correctly rendered."),deepEqual(this.parser.getExcludedGroups(),["one","two","three"],"Not able to select the new groups."),deepEqual(this.parser.deleteable(),["one","two","three"],"All groups should be deletable."),deepEqual(this.parser.getDefaults(),["one","two"],"Default rendered."),deepEqual(this.parser.groupsWithEditableDefault(),["one","two","three"],"Should be able to edit all groups."),ok(o.calledWith(["one","two","three"],["one","two"]),"Change persisted to the server.")}),test("Can remove non-default group when there are other groups present",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two"],defaultGroups:["two"]},setRole:o,IO:new s});this.region.show(a.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two"],"The groups are rendered correctly."),deepEqual(this.parser.getExcludedGroups(),["one","two"],"Not able to select initial groups."),deepEqual(this.parser.deleteable(),["one"],"Able to delete non default groups."),deepEqual(this.parser.getDefaults(),["two"],"Default rendered."),deepEqual(this.parser.groupsWithEditableDefault(),["one"],"Should be able to non-default group."),this.parser.removeGroup("one"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["two"],"Group removed from UI."),deepEqual(this.parser.getExcludedGroups(),["two"],"Now able to select deleted groups."),deepEqual(this.parser.deleteable(),[],"No groups deletable."),deepEqual(this.parser.getDefaults(),["two"],"Default rendered."),deepEqual(this.parser.groupsWithEditableDefault(),[],"Should not be able to edit any groups."),ok(o.calledWith(["two"],["two"]),"Change persisted to the server.")}),test("Remove group correctly removes group without default",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"]},setRole:o,IO:new s});this.region.show(a.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two","three"],"The groups are rendered correctly."),deepEqual(this.parser.getExcludedGroups(),["one","two","three"],"Not able to select initial groups."),deepEqual(this.parser.deleteable(),["one","two","three"],"Able to delete all groups."),deepEqual(this.parser.getDefaults(),[],"No default rendered."),deepEqual(this.parser.groupsWithEditableDefault(),["one","two","three"],"Should be able to edit all groups."),this.parser.removeGroup("one"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["two","three"],"Group removed from UI."),deepEqual(this.parser.getExcludedGroups(),["two","three"],"Not able to select remaining groups."),deepEqual(this.parser.deleteable(),["two","three"],"Remaining groups deletable."),deepEqual(this.parser.getDefaults(),[],"No default rendered."),deepEqual(this.parser.groupsWithEditableDefault(),["two","three"],"Should be able to edit all groups."),ok(o.calledWith(["two","three"],[]),"Change persisted to the server."),this.parser.removeGroup("two"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["three"],"Group removed from UI."),deepEqual(this.parser.getExcludedGroups(),["three"],"Not able to select remaining groups."),deepEqual(this.parser.deleteable(),[],"Last group cannot be removed"),deepEqual(this.parser.getDefaults(),[],"No default rendered."),deepEqual(this.parser.groupsWithEditableDefault(),["three"],"Should be able to edit all groups."),ok(o.calledWith(["three"],[]),"Change persisted to the server.")}),test("Remove default group provided there are other defaults present",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"],defaultGroups:["one","two","three"]},setRole:o,IO:new s});this.region.show(a.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two","three"],"The groups are rendered correctly."),deepEqual(this.parser.getExcludedGroups(),["one","two","three"],"Not able to select initial groups."),deepEqual(this.parser.deleteable(),["one","two","three"],"Able to delete all groups."),deepEqual(this.parser.getDefaults(),["one","two","three"],"All of them are default."),deepEqual(this.parser.groupsWithEditableDefault(),["one","two","three"],"Should be able to edit all groups."),this.parser.removeGroup("one"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["two","three"],"Group removed from UI."),deepEqual(this.parser.getExcludedGroups(),["two","three"],"Not able to select remaining groups."),deepEqual(this.parser.deleteable(),["two","three"],"Remaining groups deletable."),deepEqual(this.parser.getDefaults(),["two","three"],"All of them are default."),deepEqual(this.parser.groupsWithEditableDefault(),["two","three"],"Should be able to edit all groups."),ok(o.calledWith(["two","three"],["two","three"]),"Change persisted to the server.")}),test("Can't remove last default group",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"],defaultGroups:["one","two","three"]},setRole:o,IO:new s});this.region.show(a.view),this.parser.removeGroup("one"),this.parser.removeGroup("two"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["three"],"Group removed from UI."),deepEqual(this.parser.getExcludedGroups(),["three"],"Not able to select remaining groups."),deepEqual(this.parser.deleteable(),[],"Last group cannot be removed"),deepEqual(this.parser.getDefaults(),["three"],"All of them are default."),deepEqual(this.parser.groupsWithEditableDefault(),[],"Cannot unset last default."),ok(o.calledWith(["three"],["three"]),"Change persisted to the server.")}),test("Can't remove last non-default group",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"]},setRole:o,IO:new s});this.region.show(a.view),this.parser.removeGroup("one"),this.parser.removeGroup("two"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["three"],"Group removed from UI."),deepEqual(this.parser.getExcludedGroups(),["three"],"Not able to select remaining groups."),deepEqual(this.parser.deleteable(),[],"Last group cannot be removed"),deepEqual(this.parser.getDefaults(),[],"No default groups rendered."),deepEqual(this.parser.groupsWithEditableDefault(),["three"],"Any group can be made default."),ok(o.calledWith(["three"],[]),"Change persisted to the server.")}),test("Set default group correctly sets default when no current default",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"]},setRole:o,IO:new s});this.region.show(a.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two","three"],"The groups are rendered correctly."),deepEqual(this.parser.getExcludedGroups(),["one","two","three"],"Not able to select initial groups."),deepEqual(this.parser.deleteable(),["one","two","three"],"Able to delete all groups."),deepEqual(this.parser.getDefaults(),[],"No default rendered."),deepEqual(this.parser.groupsWithEditableDefault(),["one","two","three"],"Any group can be made default."),this.parser.setDefault("one"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two","three"],"Groups remain same after operation."),deepEqual(this.parser.getExcludedGroups(),["one","two","three"],"Still not able to select groups in role."),deepEqual(this.parser.deleteable(),["two","three"],"Only non-default groups deletable."),deepEqual(this.parser.getDefaults(),["one"],"Default has been rendered"),deepEqual(this.parser.groupsWithEditableDefault(),["two","three"],"The only default cannot be unset."),ok(o.calledWith(["one","two","three"],["one"]),"Change persisted to the server.")}),test("Defined applications will not render warning",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"],defined:!0},IO:new s});this.region.show(t.view),ok(this.parser.defined(),"Warning should not rendered because application is defined.")}),test("Undefined applications will render warning",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"],defined:!1},IO:new s});this.region.show(t.view),ok(!this.parser.defined(),"Warning should render because application is undefined.")}),test("Applications without default group will render warning.",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"]},setRole:o,IO:new s});this.region.show(a.view),ok(this.parser.noDefaultGroupWarningShowing(),"Warning should show because no default group is set"),this.parser.setDefault("one"),ok(!this.parser.noDefaultGroupWarningShowing(),"Warning shouldn't show because one group is set as a default"),this.parser.setDefault("two"),ok(!this.parser.noDefaultGroupWarningShowing(),"Warning shouldn't show because two groups are set as a default")}),test("Set default group correctly sets default when there is a current default",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two"],defaultGroups:["two"]},setRole:o,IO:new s});this.region.show(a.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two"],"The groups are rendered correctly."),deepEqual(this.parser.getExcludedGroups(),["one","two"],"Not able to select initial groups."),deepEqual(this.parser.deleteable(),["one"],"Able to delete non-default groups."),deepEqual(this.parser.getDefaults(),["two"],"Initial default rendered."),deepEqual(this.parser.groupsWithEditableDefault(),["one"],"The only default cannot be unset."),this.parser.setDefault("one"),deepEqual(this.parser.groupsWithEditableDefault(),["one","two"],"All groups should be editable."),this.parser.unsetDefault("two"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two"],"Groups remain same after operation."),deepEqual(this.parser.getExcludedGroups(),["one","two"],"Still not able to select groups in role."),deepEqual(this.parser.deleteable(),["two"],"Only non-default groups deletable."),deepEqual(this.parser.getDefaults(),["one"],"Default has been rendered"),deepEqual(this.parser.groupsWithEditableDefault(),["two"],"The only default cannot be unset."),ok(o.calledWith(["one","two"],["one"]),"Change persisted to the server.")}),test("Able to set multiple defaults",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two"]},setRole:o,IO:new s});this.region.show(a.view),this.parser.setDefault("one"),this.parser.setDefault("two"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["one","two"],"Groups remain same after operation."),deepEqual(this.parser.getExcludedGroups(),["one","two"],"Still not able to select groups in role."),deepEqual(this.parser.deleteable(),["one","two"],"All groups are deletable."),deepEqual(this.parser.getDefaults(),["one","two"],"Default has been rendered"),deepEqual(this.parser.groupsWithEditableDefault(),["one","two"],"All defaults can be unset because there are multiple."),ok(o.calledWith(["one","two"],["one","two"]),"Change persisted to the server.")}),test("Can toggle the default on all but the last default",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"],defaultGroups:["one","two","three"]},setRole:o,IO:new s});this.region.show(a.view),deepEqual(this.parser.groupsWithEditableDefault(),["one","two","three"],"All defaults can be unset because there are multiple."),this.parser.unsetDefault("one"),deepEqual(this.parser.groupsWithEditableDefault(),["one","two","three"],"All groups can be edited."),this.parser.unsetDefault("two"),deepEqual(this.parser.groupsWithEditableDefault(),["one","two"],"Last default cannot be edited."),ok(o.calledWith(["one","two","three"],["three"]),"Change persisted to the server.")}),test("Can toggle default when single non-default group available",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["one"]},setRole:o,IO:new s});this.region.show(a.view),deepEqual(this.parser.groups(),["one"],"Groups remain same after operation."),
deepEqual(this.parser.getExcludedGroups(),["one"],"Still not able to select groups in role."),deepEqual(this.parser.deleteable(),[],"Last group cannot be removed."),deepEqual(this.parser.getDefaults(),[],"No defaults rendered"),deepEqual(this.parser.groupsWithEditableDefault(),["one"],"Non-default group can be made default"),this.parser.setDefault("one"),deepEqual(this.parser.groups(),["one"],"Groups remain same after operation."),deepEqual(this.parser.getExcludedGroups(),["one"],"Still not able to select groups in role."),deepEqual(this.parser.deleteable(),[],"Last group cannot be removed."),deepEqual(this.parser.getDefaults(),["one"],"No defaults rendered"),deepEqual(this.parser.groupsWithEditableDefault(),[],"Cannot unset the only default."),ok(o.calledWith(["one"],["one"]),"Change persisted to the server.")}),test("No groups renders empty view and allows creation of new rows.",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:[]},setRole:o,IO:new s});this.region.show(a.view),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),[],"The groups are rendered correctly."),deepEqual(this.parser.getExcludedGroups(),[],"Able to select all groups."),ok(this.parser.emptyMessageShowing(),"Empty message should be showing."),this.parser.addGroup("first"),equal(this.parser.name(),"RoleId","The Role name is rendered correctly."),deepEqual(this.parser.groups(),["first"],"First group added to UI."),deepEqual(this.parser.getExcludedGroups(),["first"],"Not able to select initial group."),deepEqual(this.parser.deleteable(),[],"First group is default and cannot be deleted."),deepEqual(this.parser.getDefaults(),[],"First is not default until user explicitly decides."),ok(o.calledWith(["first"],[]),"Change persisted to the server.")}),asyncTest("HIROL-983 Selecting group as default which is used in different apps should display warning popup",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"],defaultGroups:["one"],defaultGroupsExistingInAnyOtherRoles:{"other-role":["two"]},appsReusingGroup:["Another app"]},setRole:function(){return t.promise()},IO:new s});this.region.show(o.view),this.parser.setDefault("two"),t.resolve({remainingSeats:20,numberOfSeats:30,userCount:10,hasUnlimitedSeats:!1}),setTimeout(function(){ok(!this.parser.groupDefaultWarningPopupVisible(o._groups.models[0]),"Default warning popup for group one is not visible."),ok(this.parser.groupDefaultWarningPopupVisible(o._groups.models[1]),"Default warning popup for group two should be shown."),ok(!this.parser.groupDefaultWarningPopupVisible(o._groups.models[2]),"Default warning popup for group three is not visible."),start()}.bind(this),1)}),test("HIROL-983 Selecting group as default which is not used in different apps should not display warning popup",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=new e({data:{key:"roleid",name:"RoleId",groups:["one","two","three"],defaultGroups:["one"],defaultGroupsExistingInAnyOtherRoles:{"other-role":["one"]}},setRole:function(){return t.promise()},IO:new s});this.region.show(o.view),this.parser.setDefault("three"),t.resolve({remainingSeats:20,numberOfSeats:30,userCount:10,hasUnlimitedSeats:!1}),ok(!this.parser.groupDefaultWarningPopupVisible(o._groups.models[0]),"Default warning popup for group one should not be shown."),ok(!this.parser.groupDefaultWarningPopupVisible(o._groups.models[1]),"Default warning popup for group two should not be shown."),ok(!this.parser.groupDefaultWarningPopupVisible(o._groups.models[2]),"Default warning popup for group three should not be shown")}),asyncTest("HIROL-983 Adding group which is default in different apps should display warning popup",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=new e({data:{key:"roleid",name:"RoleId",groups:["one"],defaultGroups:["one"],defaultGroupsExistingInAnyOtherRoles:{"other-role":["two"]},appsAndDefaultRoles:{"other-role":["two"]}},setRole:function(){return t.promise()},IO:new s});this.region.show(o.view),this.parser.addGroup("two"),t.resolve({remainingSeats:20,numberOfSeats:30,userCount:10,hasUnlimitedSeats:!1}),setTimeout(function(){ok(!this.parser.groupAddWarningPopupVisible(o._groups.models[0]),"Group warning popup for group one should not be visible."),ok(this.parser.groupAddWarningPopupVisible(o._groups.models[1]),"Group warning popup for group two should be visible."),start()}.bind(this),1)}),test("HIROL-983 Adding group which is not default in other apps should not display warning popup",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=new e({data:{key:"roleid",name:"RoleId",groups:["one"],defaultGroups:["one"],defaultGroupsExistingInAnyOtherRoles:{"other-role":["two"]}},setRole:function(){return t.promise()},IO:new s});this.region.show(o.view),this.parser.addGroup("two"),t.resolve({remainingSeats:20,numberOfSeats:30,userCount:10,hasUnlimitedSeats:!1}),ok(!this.parser.groupAddWarningPopupVisible(o._groups.models[0]),"Group warning popup for group one should not be visible."),ok(!this.parser.groupAddWarningPopupVisible(o._groups.models[1]),"Group warning popup for group two should not be visible.")}),test("Loading indicator shows when loading.",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:[]},setRole:o,IO:new s});this.region.show(a.view),this.parser.addGroup("first"),ok(this.parser.isLoading(),"Loading while PUT out."),t.resolve([]),ok(!this.parser.isLoading(),"Not loading after PUT finished.")}),test("Group user counts are displayed on initial load",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:["a"]},setRole:o,IO:new s});this.region.show(a.view);var i=this.parser.getGroupDetail("a");equal(i.userCount,1,"The group's user count is rendered correctly")}),test("Group user counts are gracefully not rendered if group detail is not retrieved",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new s;sinon.stub(a,"getGroupDetails").withArgs("a").returns(r.Deferred().reject());var i=new e({data:{key:"roleid",name:"RoleId",groups:["a"]},setRole:o,IO:a});this.region.show(i.view);var n=this.parser.getGroupDetail("a");equal(n.userCount,null,"The group's user count is hidden"),equal(n.name,"a","The group's name is still shown")}),test("Group user counts are displayed for added group",function(){var e=this.context.require("jira/admin/application/approleeditor"),t=r.Deferred(),o=this.stub().returns(t),a=new e({data:{key:"roleid",name:"RoleId",groups:[]},setRole:o,IO:new s});this.region.show(a.view),this.parser.addGroup("three");var i=this.parser.getGroupDetail("three");equal(i.userCount,1,"The added group's user count is rendered correctly")})}),e(function(){var e=function e(t){this.shown=!1,this.options=t,e.last=this};t.extend(e.prototype,{show:function(){this.shown=!0},isShown:function(){return this.shown},getOptions:function(){return this.options},getXhr:function(){return this.options.xhr}}),e.openErrorDialogForXHR=function(t){return new e({xhr:t})};var s=function(){return t.toArray(arguments).join(",")},n=a.ItemView.extend({template:function(e){return r("<div>").text(JSON.stringify(e.view.model.toJSON())).addClass("role-editor-test").data("view",e.view)},serializeData:function(){return{view:this}},setGroups:function(e,t){return this.options.setRole(e,t)}}),l=function(){var e=function e(t,o){var a=r.Deferred();return a.options=t,a.dialog=o,e.calls.push(a),e.callCount++,e.lastCall=a,a.promise()};return(e.reset=function(){return e.calls=[],e.callCount=0,delete e.lastCall,this})()},u=function(e){this.view=new n({model:new o.Model(e.data),setRole:e.setRole})},p=function(){this.element=r("#qunit-fixture")};t.extend(p.prototype,{isNoRoleMessageVisible:function(){return!!this.element.find("#application-role-none").length},loadingVisible:function(){return!!this.element.find("#application-role-initial-load").length},roles:function(){return this.element.find("div.role-editor-test").map(function(){return JSON.parse(r(this).text())}).get()},views:function(){return this.element.find("div.role-editor-test").map(function(){return r(this).data("view")}).get()}});var d=function(e){return e.data=JSON.parse(e.data),e},h=function(e,t,r,o,a){return{url:i+"/rest/api/2/applicationrole/"+e,dataType:"json",headers:{"If-Match":a.toString()},type:"PUT",contentType:"application/json",data:{groups:t,defaultGroups:r,selectedByDefault:o}}},c=function(e,t,r,o,a){deepEqual(d(this.ajax.lastCall.options),h(e,t,r,o,a),"Put for role called with correct arguments.")},g=function(){ok(e.last,"Error displayed."),deepEqual(e.last.options,{message:"application.access.configuration.out.of.date",mode:"warning"},"Error dialog created with correct options."),ok(e.last.isShown(),"Error dialog should be shown.")},f=function(t){ok(e.last,"Error displayed."),deepEqual(e.last.getXhr(),t,"Error dialog should be passed rejected data.")},w=function(){ok(!e.last,"No error should have been displayed.")},m=function(e,t){equal(e.state(),"resolved","Deferred resolved?");var r=this.spy();e.done(r),ok(r.called,"Done called."),deepEqual(r.firstCall.args,t,"Callback triggered with correct arguments.")},b=function(e,t){equal(e.state(),"rejected","Deferred rejected?");var r=this.spy();e.fail(r),ok(r.called,"Fail called."),deepEqual(r.firstCall.args,t,"Callback triggered with correct arguments.")},v=function(e){b.call(this,e,[null,"abort"])},q=function(e){equal(e.state(),"pending","Deferred pending?")},E=function(e){var t=e||[{key:"a",name:"a",groups:["a","z"],defaultGroups:[]},{key:"b",name:"b",groups:["c","a"],defaultGroups:["a"]}],r=this.context.require("jira/admin/application/approleseditor"),o=new r({el:this.element});return this.ajax.calls[0].resolve(t,[],y),this.ajax.reset(),o};module("Roles Editor Tests",{setup:function(){e.last=null,this.context=AJS.test.mockableModuleContext(),this.ajax=l(),this.context.mock("jira/ajs/ajax/smart-ajax/web-sudo",{makeWebSudoRequest:this.ajax}),this.context.mock("jira/dialog/error-dialog",e),this.context.mock("jira/admin/application/approleeditor",u),this.context.mock("jira/admin/application/application-role-labels",{}),this.parser=new p,this.element=r("#qunit-fixture"),this.ounload=window.onbeforeunload,window.onbeforeunload=null,this.oformat=AJS.format,AJS.format=s,this.assertFail=b,this.assertAbort=v,this.assertDone=m,this.assertGeneralErrorDisplayed=g,this.assertXhrErrorDisplayed=f,this.assertNoErrorDisplayed=w,this.createEditor=E,this.assertPut=c,this.assertPending=q},teardown:function(){AJS.format=this.oformat,window.onbeforeunload=this.ounload}});var y={getResponseHeader:function(e){return"0"}};test("Empty message shown when no roles installed",function(){new(this.context.require("jira/admin/application/approleseditor"))({el:this.element}),this.ajax.calls[0].resolve([],[],y),ok(this.parser.isNoRoleMessageVisible(),"No role message is visible.")}),test("Nothing happens when element no passed.",function(){new(this.context.require("jira/admin/application/approleseditor"))({ajax:this.ajax}),ok(!this.ajax.called,"Don't trigger a render if nothing is going to display.")}),test("Nothing happens when empty jQuery set passed.",function(){new(this.context.require("jira/admin/application/approleseditor"))({$el:r()}),ok(!this.ajax.called,"Don't trigger a render if nothing is going to display.")}),test("Loading indicator is only shown while loading.",function(){new(this.context.require("jira/admin/application/approleseditor"))({el:this.element}),ok(this.parser.loadingVisible(),"Loading indicator is visible during load."),this.ajax.calls[0].resolve([],[],y),ok(!this.parser.loadingVisible(),"Loading indicator is hidden after load.")}),test("RolesEditor sends application role request with correct AJAX options",function(){new(this.context.require("jira/admin/application/approleseditor"))({el:this.element});var e={url:i+"/rest/api/2/applicationrole",dataType:"json"};deepEqual(this.ajax.calls[0].options,e,"Get method called with correct AJAX options.")}),test("HIROL-776 Default groups reused in different roles are evaluated properly",function(){this.createEditor([{key:"a-key",name:"a-name",groups:["a","z","b"],defaultGroups:["z","b"]},{key:"b-key",name:"b-name",groups:["b","z"],defaultGroups:[]},{key:"c-key",name:"c-name",groups:["c","z"],defaultGroups:[]}]);var e=[{"b-name":["z","b"],"c-name":["z"]},{},{}];deepEqual(t.pluck(this.parser.roles(),"defaultGroupsExistingInAnyOtherRoles"),e,"Roles rendered on the page in correct order with correct parameters.")}),test("Error dialog triggered when error occurs while trying to load roles.",function(){var e={msg:"This is an error"};new(this.context.require("jira/admin/application/approleseditor"))({el:this.element}),this.ajax.calls[0].reject(e),ok(this.parser.loadingVisible(),"Loading should remain visible after the error."),this.assertXhrErrorDisplayed(e)}),test("Updating roles triggers AJAX call to server",function(){this.createEditor(),this.parser.views()[0].setGroups(["k","i","l"],["l"]),this.assertPut("a",["k","i","l"],["l"],!1,0),this.ajax.lastCall.resolve({groups:[]},[],y),this.assertNoErrorDisplayed()}),test("Error while updating roles triggers error dialog.",function(){this.createEditor();this.parser.views()[0].setGroups(["k","i","l"],["l"]),this.ajax.lastCall.reject("Error",[],y),this.assertXhrErrorDisplayed("Error")}),test("400 Error while updating roles triggers error dialog.",function(){this.createEditor();var e={status:400};this.parser.views()[0].setGroups(["k","i","l"],["l"]),this.ajax.lastCall.reject(e,"failed",y),this.assertGeneralErrorDisplayed()}),test("Updating queues put requests on slow AJAX response.",function(){this.createEditor();var e=this.parser.views()[1],t=this.ajax;e.setGroups(["a"],[]),e.setGroups(["b"],[]),e.setGroups(["c"],[]),equal(t.callCount,1,"AJAX request batched."),this.assertPut("b",["a"],[],!1,0),t.lastCall.resolve({groups:[]},[],y),equal(t.callCount,3,"AJAX request un-batched."),this.assertPut("b",["c"],[],!1,0),this.assertNoErrorDisplayed()}),test("Updating queues put requests on slow AJAX response multiple roles.",function(){this.createEditor();var e=this.parser.views(),t=e[0],r=e[1],o=this.ajax;t.setGroups(["a"],[]),r.setGroups(["b"],[]),t.setGroups(["c"],[]),equal(o.callCount,1,"AJAX request batched."),this.assertPut("a",["a"],[],!1,0),o.lastCall.resolve({groups:[]}),equal(o.callCount,3,"AJAX request batched."),this.assertPut("b",["b"],[],!1,0),o.lastCall.resolve({groups:[]},[],y),equal(o.callCount,5,"AJAX request batched."),this.assertPut("a",["c"],[],!1,0),this.assertNoErrorDisplayed()}),test("First error aborts all current and subsequent requests.",function(){this.createEditor();var e=this.parser.views(),t=e[0],r=e[1],o=this.ajax,a=t.setGroups(["a"],[]),s=r.setGroups(["b"],[]),i=t.setGroups(["c"],[]);equal(o.callCount,1,"AJAX request batched."),this.assertPut("a",["a"],[],!1,0),o.lastCall.reject("Error"),this.assertFail(a,["Error"]),this.assertAbort(s),this.assertAbort(i);var n=t.setGroups(["c"],[],!1);this.assertAbort(n)}),test("Queued requests are reject with 'abort' code when not run.",function(){this.createEditor();var e=this.parser.views()[1],t=(this.ajax,e.setGroups(["a"],[]));this.assertPending(t);var r=e.setGroups(["b"],[]);this.assertPending(t),this.assertPending(r);var o=e.setGroups(["c"],[]);this.assertPending(t),this.assertPending(o),this.assertAbort(r),this.assertNoErrorDisplayed(),this.ajax.calls[0].resolve([],[],y),this.ajax.calls[1].resolve([],[],y),this.assertDone(t,[[]]),this.assertPending(o),this.assertNoErrorDisplayed(),this.ajax.calls[2].resolve([],[],y),this.ajax.calls[3].resolve([],[],y),this.assertDone(o,[[]]),this.assertNoErrorDisplayed()}),test("Trying to leave page while updating gives warning to user until AJAX finishes with success",function(){this.createEditor();var e=this.parser.views()[1],t=this.ajax;e.setGroups(["a"],[]),equal(window.onbeforeunload(),"application.access.configuration.active.ajax","Warn user about leaving page while AJAX still active."),t.lastCall.resolve({groups:[]}),ok(!window.onbeforeunload(),"Able to leave page when AJAX finished.")}),test("Trying to leave page while updating gives warning to user until AJAX finishes with error",function(){this.createEditor();var e=this.parser.views()[1],t=this.ajax;e.setGroups(["a"],null),equal(window.onbeforeunload(),"application.access.configuration.active.ajax","Warn user about leaving page while AJAX still active."),t.lastCall.reject("Error",[],y),ok(!window.onbeforeunload(),"Able to leave page when AJAX finished.")}),test("Trying to leave page while updating gives warning to user when request queued until error.",function(){this.createEditor();var e=this.parser.views()[1],t=this.ajax;e.setGroups(["a"],[]),equal(window.onbeforeunload(),"application.access.configuration.active.ajax","Warn user about leaving page while AJAX still active."),e.setGroups(["a"],[]),t.lastCall.resolve({groups:[]}),equal(window.onbeforeunload(),"application.access.configuration.active.ajax","Warn user about leaving page while AJAX queued."),t.lastCall.reject("error",[],y),ok(!window.onbeforeunload(),"Able to leave page when AJAX finished.")}),test("Trying to leave page while updating is okay if websudo was triggered.",function(){this.createEditor();var e=this.parser.views()[1],t=this.ajax,r=e.setGroups(["a"],[]);equal(window.onbeforeunload(),"application.access.configuration.active.ajax","Warn user about leaving page while AJAX still active."),t.lastCall.dialog.beforeShow(),ok(!window.onbeforeunload(),"Able to leave page when AJAX finished."),this.assertAbort(r)}),test("Still calls old onbeforeunload function.",function(){var e=window.onbeforeunload=this.stub().returns("Error");this.createEditor();var t=this.parser.views()[1],r=this.ajax;t.setGroups(["a"],[]),equal(window.onbeforeunload(),"Error","Calls old onbeforeunload first."),e.returns(void 0),equal(window.onbeforeunload(),"application.access.configuration.active.ajax","Warn user about leaving page while AJAX still active."),r.lastCall.resolve({groups:[]}),ok(!window.onbeforeunload(),"Able to leave page when AJAX finished.")})})});