AJS.test.require(["jira.webresources:select-pickers","com.atlassian.auiplugin:ajs-underscorejs","jira.webresources:key-commands"],function(){"use strict";var e=require("jquery"),t=require("jira/ajs/select/single-select"),i=require("jira/ajs/layer/inline-layer"),l=require("jira/ajs/list/item-descriptor");module("SingleSelect",{setup:function(){this.$auiForm=e("<form class='aui'></form>").css({width:300}).appendTo("#qunit-fixture"),this.$select=e("<select id='field'><option value='1'>One</option><option selected='selected' value='2'>Two</option></select>").appendTo("#qunit-fixture")}}),test("constructor",function(){var e,i=this.spy();this.$select.bind("initialized",i),e=new t({element:this.$select,width:200}),ok(i.calledOnce,"Expected initialized event to fire"),ok(!this.$select.is(":visible"),"Expected <select> to be hidden"),ok(!e.$errorMessage.is(":visible"),"Expected error message to be hidden"),ok(e.$dropDownIcon.hasClass("drop-menu"),"Expected dropdown menu"),equal(e.$field.val(),"Two")}),test("width",function(){var e=new t({element:this.$select,width:210});e.$container.css("display","inline-block"),equal(e.$container.css("max-width"),"210px","the container's maximum width is constrained by setting width in the constructor"),notEqual(e.$container.width(),210,"the container will not be 210px initially");var i=this.$auiForm.width();e.$container.width(i+100),equal(e.$container.width(),210,"the container is constrained by its max-width to 210px"),e.setFieldWidth(i),equal(e.$container.css("max-width"),i+"px","the max-width is affected by setFieldWidth"),equal(e.$container.width(),i,"the container only grows as large as its max-width allows")}),test("getSelectedDescriptor",function(){var e=new t({element:this.$select});equal(e.getSelectedDescriptor().value(),"2","Expected selected descriptor to have a value of 2")}),test("Down arrow key opens suggestions",function(){var t=sinon.useFakeTimers(),i=new AJS.SingleSelect({element:this.$select});t.tick(200);var l=new e.Event("keydown");l.keyCode=40,l.which=40,i.$field.trigger(l),ok(i.dropdownController.isVisible(),"Dropdown layer is visible")}),test("Aria-activedescendant points to the correct item",function(){var t=sinon.useFakeTimers(),i=new AJS.SingleSelect({element:this.$select});t.tick(200);var l=new e.Event("keydown");l.keyCode=40,l.which=40,i.$field.trigger(l),t.tick(50),ok(i.$field.attr("aria-activedescendant").startsWith("one"),"Aria-activedescendant points to the correct item.")}),test("getDisplayVal",function(){var e=new t({element:this.$select,itemAttrDisplayed:"value"}),i=new l({value:"Scott",label:"Scott's label"});equal(e.getDisplayVal(i),"Scott","Expected the value to be display value")}),test("getQueryVal",function(){var e=new t({element:this.$select,itemAttrDisplayed:"value"});e.$field.val("test"),equal(e.getQueryVal(),"","Expected query value to be '' when not in editing mode"),e._setEditingMode(),equal(e.getQueryVal(),"test","Expected query value to be 'test' when in editing mode")}),test("setSelection",function(){var e=new t({element:this.$select,itemAttrDisplayed:"value"}),i=this.$select.find(":selected").data("descriptor"),l=this.spy();ok(this.$select.find(":selected").data("descriptor")==i),i=this.$select.find("option:first").data("descriptor"),this.$select.bind("selected",l),e.setSelection(i),ok(!e.$container.hasClass("aui-ss-editing"),"expected field to be in read mode (not editing)"),ok(l.calledOnce,"Expected [select] event to fire"),ok(this.$select.find(":selected").data("descriptor")==i,"Selected descriptor did not change")}),test("setSelection - anti XSS test",function(){var e=new t({element:this.$select,itemAttrDisplayed:"value"}),i=this.$select.find(":selected").data("descriptor"),l={xssCall:function(){}};sinon.mock(l).expects("xssCall").never(),window.xssCall=l.xssCall,i.icon=function(){return'genericissue.png"><script>window.xssCall()<\/script>'},e.setSelection(i),window.xssCall=null,expect(0)}),test("clearSelection",function(){var e=new t({element:this.$select,itemAttrDisplayed:"value"}),i=this.spy();this.$select.bind("unselect",i),e.clearSelection(),equal(this.$select.find(":selected").length,0,"Expected no selected <option>s"),ok(i.calledOnce,"Expected unselect event to fire")}),test("_handleEdit",function(){var e=new t({element:this.$select,itemAttrDisplayed:"value"});e.onEdit({}),e.$field.trigger("keyup"),equal(this.$select.find(":selected").length,0,"Expected any editing to unselect selected")}),test("handleFreeInput",function(){var i=e("<select><option value='fred'>Fred</option><option value='fred2'>Fred</option></select>").appendTo("#qunit-fixture"),l=new t({element:i,itemAttrDisplayed:"value"});l.$container.addClass("aui-ss-editing"),l.$field.val("Fred"),l.handleFreeInput(),equal(i.val(),"fred"),i=e("<select><option value='fred'>Fred</option><option value='fred2' selected='selected'>Fred</option></select>").appendTo("#qunit-fixture"),l=new t({element:i,itemAttrDisplayed:"value"}),l.handleFreeInput(),equal(i.val(),"fred2")}),test("reversion of invalid selections when user types freely in control",function(){this.clock=this.sandbox.useFakeTimers();var i=e("<select><option value='fred' selected='selected'>Fred</option><option value='john'>Johnny</option></select>").appendTo("#qunit-fixture"),l=new t({element:i,revertOnInvalid:!0});this.clock.tick(20),equal(i.val(),"fred","selection should initially be Fred"),l.$field.val("Johnny"),l.$field.trigger("input"),l.$field.trigger("blur"),equal(i.val(),"john","selection changed to Johnny based on typing"),equal(l.$field.val(),"Johnny"),l.$field.val("Bob"),l.$field.trigger("input"),l.$field.trigger("blur"),equal(i.val(),"john","The value should stay on the valid one.")}),test("fires a change event when reverting an invalid selection",function(){this.clock=this.sandbox.useFakeTimers();var i=this.spy(),l=e("<select><option value='fred' selected='selected'>Fred</option><option value='john'>John</option></select>").appendTo("#qunit-fixture"),n=new t({element:l,revertOnInvalid:!0});this.clock.tick(20),n.$field.on("change",i),n.$field.val("Bob"),n.$field.trigger("input"),n.$field.trigger("blur"),equal(l.val(),"fred","The value should stay on the valid one."),equal(i.callCount,1,"the change event was fired")}),test("JRA-26756: Customware issue",function(){var i=e.ajax;e.ajax=function(e){e.success({},"success",{status:200}),e.complete({status:200},"success",{status:200})};var n=new l({value:"-2",label:"Invalid Worklogs",allowDuplicate:!1}),s=e('<select id="tempo-report-search-picker" class="tempo-single-search-picker" name="search_filter" data-container-class="medium" data-input-text="">\n    <optgroup id="tempo-report-search-suggested"\n              data-weight="0">\n        <option value="10320"\n                selected="selected"\n                data-field-text="Hermione&#39;s � private filter"\n                data-field-label="Hermione&#39;s � private filter">Hermione&#39;s � private filter\n        </option>\n    </optgroup>\n</select>').appendTo("#qunit-fixture"),a=new t({element:s,showDropdownButton:!0,removeOnUnSelect:!0,submitInputVal:!0,noQueryNoRequest:!1,ajaxOptions:{query:!0,url:"blah",formatResponse:function(){var e=new AJS.GroupDescriptor({weight:0,id:"tempo-report-project-search-0",replace:!0,label:"Standard"});e.addItem(n);var t=new AJS.GroupDescriptor({weight:1,id:"tempo-report-project-search-1",replace:!0,label:"Filters"});return t.addItem(new l({value:"10021",label:"%3a%2f%3f%23%5b%5d%40%21%24%26%27%28%29%2a%2b%2c%3b%3d",allowDuplicate:!1})),t.addItem(new l({value:"10012",label:"&",allowDuplicate:!1})),t.addItem(new l({value:"10020",label:"<SCRIPT SRC=http://ha.ckers.org/xss.js><\/script>",allowDuplicate:!1})),t.addItem(new l({value:"10022",label:"<script src=http://www.example.com/malicious-code.js><\/script>",allowDuplicate:!1})),t.addItem(new l({value:"10016",label:"Bugs",allowDuplicate:!1})),t.addItem(new l({value:"10321",label:"bulk rapid",allowDuplicate:!1})),t.addItem(new l({value:"10320",label:"Hermione's � private filter",allowDuplicate:!1})),t.addItem(new l({value:"10121",label:"Hermione_filter",allowDuplicate:!1})),[e,t]}}});a.$field.focus(),a.$dropDownIcon.click(),a.setSelection(n),a.setSelection(n),ok(n==a.getSelectedDescriptor()),e.ajax=i}),test("triggering show/hide event shows/hide suggestions",function(){new t({element:this.$select}),this.$select.trigger("showSuggestions"),ok(i.current,"Expected suggestions to show"),this.$select.trigger("hideSuggestions"),ok(!i.current,"Expected suggestions to hide")}),test("setting as uneditable should render it as a disabled input box",function(){var e=new t({element:this.$select,uneditable:!0});ok(e.$container.find(".drop-menu").hasClass("hidden"),"Should have hidden the dropdown menu icon"),equal(e.$container.find("input").attr("disabled"),"disabled","Input should be disabled")}),test("enabling and disabling dynamically disables the field making it unedtiable",function(){var e=new t({element:this.$select,uneditable:!0});e.enable(),ok(!e.$container.find(".drop-menu").hasClass("hidden"),"Should have not hidden the dropdown menu icon"),equal(e.$container.find("input").attr("disabled"),void 0,"Input should not be disabled"),e.disable(),ok(e.$container.find(".drop-menu").hasClass("hidden"),"Should have hidden the dropdown menu icon"),equal(e.$container.find("input").attr("disabled"),"disabled","Input should be disabled")}),test("Setting as disabled in the constructor converts it an input box with no suggestions",function(){new t({element:this.$select,disabled:!0});var i=e("#field");equal(i.prop("tagName"),"INPUT","Should have generated an input box for a disabled SingleSelect"),equal(i.attr("type"),"text","Should be a text box"),ok(!i[0].hasAttribute("disabled"),"Should not be disabled")}),module("SingleSelect with placeholder",{setup:function(){this.$auiForm=e("<form class='aui'></form>").css({width:300}).appendTo("#qunit-fixture"),this.$select=e("<select><option value='1'>One</option><option selected='selected' value='2'>Two</option></select>").appendTo("#qunit-fixture"),this.$placeholderOption=e("<option data-placeholder='true'>Select an option</option>"),this.$select.append(this.$placeholderOption)}}),test("the input field gets an html5 placeholder attribute",function(){var e=new t({element:this.$select});equal(e.$field.attr("placeholder"),this.$placeholderOption.text(),"should use the text from the <option> marked as a placeholder")}),test("placeholders shouldn't stay in the selectable options",function(){equal(this.$select.find(this.$placeholderOption).length,1),new t({element:this.$select}),equal(this.$select.find(this.$placeholderOption).length,0)}),test("Reverts to empty value if placeholder value initially selected",function(){this.clock=this.sandbox.useFakeTimers(),this.$select.find("option").attr("selected",!1),this.$placeholderOption.attr("selected",!0).val("invalid");var e=new t({element:this.$select,revertOnInvalid:!0});this.clock.tick(20),equal(this.$select.val(),null,"selection should not be set"),equal(e.model.getValue(),null,"value should not be set"),equal(e.$field.val(),"","the field has no text in it"),e.$field.val("Seven"),e.$field.trigger("input"),e.$field.trigger("blur"),equal(e.model.getValue(),"","value should be empty"),equal(e.$field.val(),"","the field has no text in it");var i=this.$select.find(":selected");equal(i.length,1,"an interesting new empty option should appear"),equal(i.val(),"","the new option has an empty value"),equal(this.$select.find(i).length,1),e.$field.val("One"),e.$field.trigger("input"),e.$field.trigger("blur"),equal(this.$select.find(i).length,0,"it's gone now")})});