AJS.test.require(["jira.webresources:util"],function(){var e=require("underscore"),r=require("jira/ajs/ajax/ajax-util");module("AjaxUtil");var o=function(r,o){return{status:r,responseText:e.isObject(o)?JSON.stringify(o):o}};test("isWebSudoFailure classifies XHR result",function(){var e={message:"This resource requires WebSudo.","status-code":401};ok(r.isWebSudoFailure(o(401,e)),"Websudo detected."),ok(!r.isWebSudoFailure(o(401,null)),"Websudo not detected when null responseText."),ok(!r.isWebSudoFailure(o(401,void 0)),"Websudo not detected when undefined responseText."),ok(!r.isWebSudoFailure(o(401,"something")),"Websudo not detected when responseText not relevant."),ok(!r.isWebSudoFailure(o(401,!0)),"Websudo not detected when responseText wrong type."),ok(!r.isWebSudoFailure(o(400,"websudo")),"Websudo not detected on wrong status code."),ok(!r.isWebSudoFailure(o(null,"websudo")),"Websudo not detected on null status code."),ok(!r.isWebSudoFailure(o(void 0,"websudo")),"Websudo not detected on undefined status code."),ok(!r.isWebSudoFailure(o("401","websudo")),"Websudo not detected when status code wrong type."),ok(!r.isWebSudoFailure(o(200,e)),"Websudo not detected on 200 status ever."),ok(!r.isWebSudoFailure(o(null,void 0)),"Websudo not detected bad status and responseText."),ok(!r.isWebSudoFailure(null),"Websudo not detected null XHR passed."),ok(!r.isWebSudoFailure(void 0),"Websudo not detected undefined XHR passed."),ok(!r.isWebSudoFailure(!0),"Websudo not detected when truthy value passed."),ok(!r.isWebSudoFailure(!1),"Websudo not detected when wrong type passed."),ok(!r.isWebSudoFailure(10101),"Websudo not detected when number passed.")}),test("getErrorMessageFromXHR uses ErrorCollection in body to generate message",function(){equal(r.getErrorMessageFromXHR(o(401,{errorMessages:["Error"]})),"Error","Single errorMessage used."),equal(r.getErrorMessageFromXHR(o(401,{errorMessages:["Error","Error 2"]})),"Error Error 2","Multiple errorMessages used."),equal(r.getErrorMessageFromXHR(o(401,{errors:{error:"Error"}})),"Error","Single error used."),equal(r.getErrorMessageFromXHR(o(401,{errors:{error:"Error",error2:"Error 2"}})),"Error Error 2","Multiple errors used."),equal(r.getErrorMessageFromXHR(o(401,{errorMessages:[],errors:{error:"Error",error2:"Error 2"}})),"Error Error 2","Multiple errors used when errorMessages empty"),equal(r.getErrorMessageFromXHR(o(401,{errorMessages:["NonEmpty"],errors:{error:"Error",error2:"Error 2"}})),"NonEmpty","Ignore error messages when errorMessage available.")}),test("getErrorMessageFromXHR uses XHR to generate message when ErrorCollection not available.",function(){equal(r.getErrorMessageFromXHR(o(401,void 0)),"common.ajax.unauthorised.alert","Error message returned when no error collection."),equal(r.getErrorMessageFromXHR(o(204,"<xml>badErrorCollection<a></a></xml>")),"common.ajax.servererror","Error message returned with bad error collection.")})});