function retrievePercentComplete(url) {
    var moduleId = "hercules";
    var container = AJS.$("#" + moduleId + "-details");
    container.data("oldContent", container.html());
    AJS.$.ajax({
        async: "true",
        cacheBoolean: "false",
        dataType: "html",
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            displayPercentComplete("0", XMLHttpRequest);
        },
        success: function (data, textStatus, XMLHttpRequest) {
            displayPercentComplete(data, XMLHttpRequest);
        },
        timeout: 10000,
        type: "GET",
        url: url
    });
}

function displayPercentComplete(data, XMLHttpRequest) {
    // Don't refresh the Hercules log scan progress if the status returned is 204 No Content
    if (XMLHttpRequest.status != 204) {
        var jsonData = JSON.parse(data);
        var percent = jsonData.progressPercentage;

        AJS.$(".stp-progress-amount").css("width", percent + "%");
        AJS.$(".stp-progress-bar-percent").html(percent);
        if (jsonData.progressMessage) {
            AJS.$(".stp-progress-text").text(jsonData.progressMessage)
        }

        if (jsonData.available) {
            refreshHerculesModule();
        }
        else {
            refreshPercentComplete(2);
        }
    }
}

function refreshHerculesModule() {
    var servletHomePath = AJS.$("#hercules").data("servletHomePath");
    var scanId = AJS.$("#hercules").data("scanId");
    var startTime = AJS.$("#hercules").data("startTime");

    atstGetPageViaAjax("hercules", servletHomePath + "/hercules/execute?scanId=" + scanId + "&startTime=" + startTime);
}

function refreshPercentComplete(delay) {
    var url = AJS.$("#hercules").data("statusUrl");
    setTimeout(function () {
        retrievePercentComplete(url)
    }, delay * 1000);
}

function herculesToggleLogOptions() {
    var selectedOption = AJS.$("#herculesLogToggle").val();
    if (selectedOption != "Custom Log") {
        AJS.$("#logFilePath").hide();
        AJS.$("#logFilePath").val(selectedOption);
    }
    else {
        AJS.$("#logFilePath").show();
    }
}

// A function to rerun Hercules scanner and update a container with the results
// This function should only be bounce to the refresh button or the edit log file path field
// This function is a copy of atstSubmitFormViaAjax function, but tailored to work for buttons/field
function rerunHerculesScanViaAjax(event, $this) {
    // "this" = the refresh button/log file path contained in the form
    event.preventDefault();

    var moduleId = AJS.$($this).closest(".troubleshooting-module").attr("id");

    if (moduleId != null) {
        var $form = AJS.$("#" + moduleId + " #refresh-scan");
        var formData = $form.serialize();
        var formAction = $form.attr("action");

        var $container = atstGetContainer(moduleId);
        $container.data("oldContent", $container.html());
        $container.html("");
        $container.addClass("loading");
        $container.removeClass("loaded");

        AJS.$.ajax({
            async: "true",
            // This has to be quite high to allow mail timeouts to function correctly.
            timeout: 325000,
            cacheBoolean: "false",
            data: formData,
            dataType: "html",
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                atstDisplayAjaxError(moduleId, XMLHttpRequest, textStatus, errorThrown);
            },
            success: function (data, textStatus, XMLHttpRequest) {
                atstDisplayAjaxResults(moduleId, data);
            },
            type: "POST",
            headers: {
                "X-Atlassian-Token": "no-check"
            },
            url: formAction
        });
    }
}

function updateButtons() {
    var paginationList = AJS.$("#stp-hercules-results-pagination");
    var numPages = Math.ceil(numResults / pageSize);
    var prevPage = Math.max(1, currentPage - 1);
    var nextPage = Math.min(numPages, currentPage + 1);
    var pagesBefore = 4;
    var pagesAfter = 4;

    paginationList.empty();

    if (currentPage != prevPage) {
        paginationList.append('<li class="aui-nav-previous"><a id="stp-hercules-results-previous" href="#">Prev</a></li>');
        AJS.$("#stp-hercules-results-previous").click({page: prevPage}, moveToPage);
    } else {
        paginationList.append('<li class="aui-nav-previous"><a id="stp-hercules-results-previous" href="#" aria-disabled="true">Prev</a></li>');
    }

    for (var i = Math.max(1, currentPage - pagesBefore); i <= Math.min(numPages, currentPage + pagesAfter); i++) {
        if (i == currentPage) {
            paginationList.append('<li class="aui-nav-selected">' + i + '</li>');
        } else {
            paginationList.append('<li><a id="stp-hercules-results-page-' + i + '" href="#">' + i + '</a></li>');
            AJS.$("#stp-hercules-results-page-" + i).click({page: i}, moveToPage);
        }
    }

    if (currentPage != nextPage) {
        paginationList.append('<li class="aui-nav-next"><a id="stp-hercules-results-next" href="#">Next</a></li>');
        AJS.$("#stp-hercules-results-next").click({page: nextPage}, moveToPage);
    } else {
        paginationList.append('<li class="aui-nav-next"><a id="stp-hercules-results-next" href="#" aria-disabled="true">Next</a></li>');
    }
}

function setViewport() {
    AJS.$("#stp-hercules-results table tbody tr").show();

    if (startPosition > 0) {
        AJS.$("#stp-hercules-results table tbody tr:lt(" + startPosition + ")").hide();
    }
    if (endPosition < numResults) {
        AJS.$("#stp-hercules-results table tbody tr:gt(" + (endPosition - 1) + ")").hide();
    }
    AJS.$("#stp-hercules-results-start-position").text(startPosition + 1);
    AJS.$("#stp-hercules-results-end-position").text(endPosition);

    updateButtons();
}

function moveToPage(event) {
    var page = event.data.page;
    var numPages = Math.ceil(numResults / pageSize);

    if (page >= 1 && page <= numPages) {
        startPosition = (page - 1) * pageSize;
        if (numResults < startPosition + pageSize) {
            endPosition = numResults;
        }
        else {
            endPosition = startPosition + pageSize;
        }
        currentPage = page;
        event.preventDefault();
        setViewport();
    }
}

// Add the periodic scan button and attach the button click event handler. Additionally, we also initialize the log filter option if the result is not empty
function initLogAnalyzerControlPanel(shouldDisplayLogFilters) {
    "use strict";
    var $elem = AJS.$('#stp-log-analyzer-control');

    if (shouldDisplayLogFilters) {
        $elem.append(Stp.Templates.LogAnalyzer.scanResultsFilters());
        attachLogFilterOptionsEvent();
    }

    AJS.$("#periodic-log-analyzer-button").click(function () {
        var dialog = new AJS.Dialog({
            width: 800,
            height: 410,
            id: "log-analyzer-settings",
            closeOnOutsideClick: true
        });

        // get the atl_token from hidden input on Log Analyzer tab
        var atl_token = document.getElementsByName('atl_token')[0].value;
        var url = AJS.contextPath() + "/rest/troubleshooting/latest/hercules/periodicScanner/settings";

        AJS.$.getJSON(url, function () {
        }).done(function (data) {
            dialog.addPanel("SinglePanel", Stp.Templates.LogAnalyzer.toggleLogAnalyzerDialog({
                token: atl_token,
                isEnabled: data.isEnabled,
                recipients: data.recipients,
                startHour: data.startHour,
                startMinute: data.startMinute,
                frequencyOptions: data.frequencyOptions,
                frequency: data.frequency
            }), "periodicLogAnalyzer");
        });

        dialog.show();
        AJS.trigger('analyticsEvent', {name: 'stp.log.analyzer.periodic.scan.clicked'});

        // Attach handler to detect if a dialog is closed to remove the shown dialog from page
        AJS.$(document).on("hideLayer", function (e, type, popup) {
            if (type === "popup" && popup === dialog.popup) {
                popup.remove();
            }
        });
    });
}

function attachLogFilterOptionsEvent() {
    "use strict";
    AJS.$('#urgency-filter .result-filter-option').on('click', function (event) {

        var urgencyType = ["urgency-high", "urgency-medium", "urgency-low"];

        var $this = AJS.$(this);
        var clickedFilter = $this.attr("id");
        var clickedFilterClass = $this.attr('class').split(' ');

        if (clickedFilterClass.length > 1 && clickedFilterClass[1] == 'active') {
            var index = enabledResultFilter.indexOf(clickedFilter);
            enabledResultFilter.splice(index, 1);

            $this.removeClass('active');
            triggerAnalyticsEvent(clickedFilter, "disabled");
        }
        else {
            enabledResultFilter.push(clickedFilter);

            $this.addClass('active');
            triggerAnalyticsEvent(clickedFilter, "enabled");
        }

        var $resultTable = AJS.$('#log-scan-results-table');
        // If the result filter is disabled, we show all the results and re-enable the pagination
        if (enabledResultFilter.length == 0) {
            $resultTable.find(".urgency-high").show();
            $resultTable.find(".urgency-medium").show();
            $resultTable.find(".urgency-low").show();

            AJS.$('#stp-hercules-results-buttons').show();
            setViewport();
        }
        else {
            urgencyType = urgencyType.filter(function (val) {
                return enabledResultFilter.indexOf(val) == -1;
            });

            // Hide results pagination and show all results in the table, then we filter the rows based on the urgency type
            AJS.$('tr').show();
            AJS.$('#stp-hercules-results-buttons').hide();

            AJS.$.each(urgencyType, function (idx, val) {
                AJS.$("." + val).hide();
            });

            AJS.$.each(enabledResultFilter, function (idx, val) {
                AJS.$("." + val).show();
            });

            // Once the result filter is enabled, we need to remove any duplicated restart bar
            filterDuplicatedRestartBar();
        }

        event.preventDefault();

    });
}

// Function to initialize inline edit field on click
function initInlineEditFn() {
    AJS.$.fn.inlineEdit = function (replaceWith, connectWith) {

        AJS.$(this).hover(function () {
            AJS.$(this).addClass('hover');
        }, function () {
            AJS.$(this).removeClass('hover');
        });

        AJS.$(this).click(function () {

            var elem = AJS.$(this);

            elem.hide();
            elem.after(replaceWith);
            replaceWith.focus();

            replaceWith.blur(function () {
                updateInlineEditedField(elem, AJS.$(this), connectWith);
            });
        });
    };
}

// Function to update inline edited field
function updateInlineEditedField(elem, replaceWith, connectWith) {
    if (replaceWith != "" && replaceWith.val() != connectWith.val()) {
        connectWith.val(replaceWith.val()).change();
        elem.text(replaceWith.val());
    }

    replaceWith.remove();
    elem.show();
}

function filterDuplicatedRestartBar() {
    "use strict";
    var $results = AJS.$('tr:visible');
    var $currentRow = null;

    AJS.$.each($results, function (idx, val) {
        if ($currentRow != null) {
            if (AJS.$($currentRow).find('td.application-restart').length > 0
                && AJS.$(val).find('td.application-restart').length > 0) {

                AJS.$(this).hide();

            }
        }

        $currentRow = val;
    });
}

// Function to handle periodic log analyzer form submission
function submitAnalyzerSettings() {
    var postUrl = AJS.contextPath() + "/rest/troubleshooting/latest/hercules/periodicScanner/settings";
    var params = AJS.$("#periodic-analyzer-settings").serialize();
    var $dialogBody = AJS.$(".periodicLogAnalyzer .troubleshooting-module-container-block");

    AJS.$.ajax({
        url: postUrl,
        type: 'POST',
        contentType: 'application/x-www-form-urlencoded',
        headers: {'X-Atlassian-Token': 'no-check'},
        data: params,
        success: function (data) {
            removeDialogMessages();
            $dialogBody.before(Stp.Templates.LogAnalyzer.periodicAnalyzerDialogMessage({
                type: 'success',
                content: data.feedback
            }));
        },
        error: function (data) {
            var responseMessage = JSON.parse(data.responseText);

            if (responseMessage["tokenError"]) {
                clearDialogContents();
                $dialogBody.before(Stp.Templates.LogAnalyzer.periodicAnalyzerTokenErrorMessage({content: responseMessage["tokenError"]}));
            }
            else {
                removeDialogMessages();
                $dialogBody.before(Stp.Templates.LogAnalyzer.periodicAnalyzerDialogMessage({
                    type: 'error',
                    content: responseMessage["errors"]
                }));
            }
        }
    });
}

function clearDialogContents() {
    removeDialogMessages();
    AJS.$(".periodicLogAnalyzer .troubleshooting-module-container-block").empty();
}

function removeDialogMessages() {
    var $message = AJS.$("#periodic-dialog-message");
    if ($message.length > 0) {
        $message.remove();
    }
}

function triggerAnalyticsEvent(filter, action) {
    "use strict";
    AJS.trigger('analyticsEvent', {
        name: 'stp.log.analyzer.urgency.filter.' + action,
        data: {urgencyFilter: filter}
    });
}

function triggerAnalyticsForAllResults() {
    var analyticsToSend = new Array();
    var resultsTable = document.getElementById('log-scan-results-table');

    // Start at 1, because we don't want the first row (it's a table header:
    for (i = 1; i < resultsTable.rows.length; i++) {
        if (AJS.$(resultsTable.rows[i]).find('.application-restart').length) {
            analyticsToSend.push(createResultAnalyticsObject(
                'application-restart',
                '-',
                'application-restart',
                AJS.$(resultsTable.rows[i].cells[0]).data('last-occurence'),
                1,
                'RESTART'
            ));
        } else if (AJS.$(resultsTable.rows[i]).find('.icon-bug').length) {
            var patternId = AJS.$(resultsTable.rows[i].cells[2]).children('a').data('pattern-id');

            var issueNumberPattern = /\d+/g;
            var projectKeyPattern = /([A-Z])\w+/g;

            var projectKey = projectKeyPattern.exec(patternId);
            var issueNumber = issueNumberPattern.exec(patternId);

            analyticsToSend.push(createResultAnalyticsObject(
                'bug',
                projectKey[0],
                issueNumber,
                AJS.$(resultsTable.rows[i].cells[3]).data('last-occurence'),
                AJS.$(resultsTable.rows[i].cells[2]).children('a').data('match-count'),
                AJS.$(resultsTable.rows[i].cells[1]).html().trim()
            ));
        } else if (AJS.$(resultsTable.rows[i]).find('.icon-kb').length) {
            analyticsToSend.push(createResultAnalyticsObject(
                'kb',
                '-',
                AJS.$(resultsTable.rows[i].cells[2]).children('a').data('pattern-id').replace('KB', '-KB-'),
                AJS.$(resultsTable.rows[i].cells[3]).data('last-occurence'),
                AJS.$(resultsTable.rows[i].cells[2]).children('a').data('match-count'),
                AJS.$(resultsTable.rows[i].cells[1]).html().trim()
            ));
        }
    }

    // Send them off!
    for (i = 0; i < analyticsToSend.length; i++) {
        AJS.trigger('analyticsEvent', {
            name: 'stp.log.analyzer.display',
            data: analyticsToSend[i]
        });
    }
}

function createResultAnalyticsObject(type, project, docId, time, count, urgency) {
    return {
        type: type,
        project: project,
        docId: docId,
        time: time,
        count: count,
        urgency: urgency,
        scanId: AJS.$("#hercules").data("scanId")
    };
}