AJS.test.require(["com.atlassian.jira.jira-header-plugin:newsletter-signup-tip"], function () {
    var jQuery = require("jquery");
    var HelpTipManager = require("jira-help-tips/feature/help-tip-manager");
    var analytics = require("jira/analytics");
    var underscore = require("atlassian/libs/underscore-1.8.3");
    module('Newsletter render code', {
        setup: function setup() {
            this.newsLetterSignup = require('jira/newsletter/signuptip');
            this.container = jQuery("<div>").attr("id", "content").appendTo("#qunit-fixture");
            this.trigger = jQuery("<div id=\"user-options\"></div>").appendTo("#qunit-fixture");

            this.sandbox = sinon.sandbox.create();
            this.sandbox.useFakeServer();
            this.sandbox.useFakeTimers();

            HelpTipManager.dismissedTipIds = [];
        },

        teardown: function teardown() {
            jQuery("body").off("submit", "form.aui.insiders-signup-form"); //unbind the body submit handler to ensure consecutive tests don't interfere with each other

            this.sandbox.clock.tick(0);
            this.sandbox.restore();
            this.sandbox.server.restore();
        },

        _initNewsletterSignupDialog: function _initNewsletterSignupDialog(email, url) {
            this.newsLetterSignup.render({
                userEmail: email,
                formUrl: url,
                signupTitle: "title",
                signupDescription: "description",
                signupId: "id"
            });

            this.sandbox.clock.tick(10000); //give the helptip up to 10s to show
        }
    });

    test("Sign up form is not shown if there are flags visible", function () {
        var myFlag = AJS.flag(); // add a visible flag

        try {
            this._initNewsletterSignupDialog("test@example.com", "https://www.atlassian.com/newsletter/signup");
            equal(this.container.find(".jira-help-tip .insiders-signup-form").length, 0, "Help tip should not appear when flag is present");
        } finally {
            myFlag.close();
        }
    });

    test("Test e-mail validation", function () {
        this._initNewsletterSignupDialog("test@example.com", "https://www.atlassian.com/newsletter/signup");

        this.container.find("input[name=jira-newsletter-user-email]").val("invalidemail!!!");
        this.container.find("form.aui.insiders-signup-form").submit();

        equal(this.container.find("input[name=jira-newsletter-user-email]").next(".error").text(), "newsletter.signup.tip.error.email", "Should have rendered an error about e-mail");
        equal(this.sandbox.server.requests.length, 0, "Invalid form should not call any request.");
    });

    test("Test opt-in validation", function () {
        this._initNewsletterSignupDialog("test@example.com", "https://www.atlassian.com/newsletter/signup");

        this.container.find("input[name=jira-newsletter-user-email]").val("test@email.com");
        this.container.find("form.aui.insiders-signup-form").submit();

        equal(this.container.find("input[name=jira-newsletter-opt-in]").parent().next(".error").text(), "newsletter.signup.tip.error.opt-in", "Should have rendered an error about required opt-in");

        equal(this.sandbox.server.requests.length, 0, "Invalid form should not call any request.");
    });

    test("Valid e-mail submit triggers cross-domain request to address entered if role selected to qa", function () {
        this._initNewsletterSignupDialog("valid@email.com", "https://www.atlassian.com/newsletter/signup/{0}");

        this.container.find("input[name=jira-newsletter-user-email]").val("valid@email.com");
        this.container.find("select[name=jira-newsletter-role]").val("qa");
        this.container.find("input[name=jira-newsletter-opt-in]").click();
        this.container.find("form.aui.insiders-signup-form").submit();

        equal(this.sandbox.server.requests[0].method, "POST", "Correct request method used");
        equal(this.sandbox.server.requests[0].url, "https://www.atlassian.com/newsletter/signup/valid@email.com", "Correct url used");
        equal(this.sandbox.server.requests[0].requestBody, JSON.stringify({ role: "qa", lang: "en" }), "Selected role attached to request");
    });

    test("Valid e-mail submit triggers cross-domain request to address entered if role selected to other", function () {
        this._initNewsletterSignupDialog("valid@email.com", "https://www.atlassian.com/newsletter/signup/{0}");

        this.container.find("input[name=jira-newsletter-user-email]").val("valid@email.com");
        this.container.find("select[name=jira-newsletter-role]").val("other");
        this.container.find("#jira-newsletter-other-role-name").val("role name");
        this.container.find("input[name=jira-newsletter-opt-in]").click();
        this.container.find("form.aui.insiders-signup-form").submit();

        equal(this.sandbox.server.requests[0].method, "POST", "Correct request method used");
        equal(this.sandbox.server.requests[0].url, "https://www.atlassian.com/newsletter/signup/valid@email.com", "Correct url used");
        equal(this.sandbox.server.requests[0].requestBody, JSON.stringify({ role: "other", otherRoleName: "role name", lang: "en" }), "Selected role attached to request");
    });

    test("Verify if proper analytics were send if selected role is is qa", function () {
        this.sandbox.server.respondWith("POST", "https://www.atlassian.com/newsletter/signup/valid@email.com", [200, { "Content-Type": "application/json" }, "{}"]);
        this.sandbox.server.respondImmediately = true;

        var analyticsSendSpy = this.sandbox.stub(analytics, "send");

        this._initNewsletterSignupDialog("valid@email.com", "https://www.atlassian.com/newsletter/signup/{0}");

        this.container.find("input[name=jira-newsletter-user-email]").val("valid@email.com");
        this.container.find("select[name=jira-newsletter-role]").val("qa");
        this.container.find("#jira-newsletter-other-role-name").val("");
        this.container.find("input[name=jira-newsletter-opt-in]").click();
        this.container.find("form.aui.insiders-signup-form").submit();

        equal(analyticsSendSpy.calledWith({
            name: "jira.newsletter.signuptip.submitted",
            data: {
                role: "qa",
                lang: "en",
                flagsVisible: 0,
                checksum: sinon.match.number,
                signupTipDelay: sinon.match.number
            }
        }), true, "Called analytics with proper data");
    });

    test("Verify if proper analytics were send if selected role is other", function () {
        this.sandbox.server.respondWith("POST", "https://www.atlassian.com/newsletter/signup/valid@email.com", [200, { "Content-Type": "application/json" }, "{}"]);
        this.sandbox.server.respondImmediately = true;

        var analyticsSendSpy = this.sandbox.stub(analytics, "send");

        this._initNewsletterSignupDialog("valid@email.com", "https://www.atlassian.com/newsletter/signup/{0}");

        this.container.find("input[name=jira-newsletter-user-email]").val("valid@email.com");
        this.container.find("select[name=jira-newsletter-role]").val("other");
        this.container.find("#jira-newsletter-other-role-name").val("role name");
        this.container.find("input[name=jira-newsletter-opt-in]").click();
        this.container.find("form.aui.insiders-signup-form").submit();

        equal(analyticsSendSpy.calledWith({
            name: "jira.newsletter.signuptip.submitted",
            data: {
                role: "other",
                otherRoleName: "role name",
                lang: "en",
                flagsVisible: 0,
                checksum: sinon.match.number,
                signupTipDelay: sinon.match.number
            }
        }), true, "Called analytics with proper data");
    });

    test("Test description and title rendered correctly", function () {
        this._initNewsletterSignupDialog("someOtherMail@test.com", "https://www.atlassian.com/newsletter/signup2/{0}");

        var title = this.container.find("h2.helptip-title").text();
        var description = this.container.find("div>p").text();

        equal(title, "title", "Title rendered correctly");
        equal(description, "description", "Description rendered correctly");
    });

    test("Test if other role is hidden on beginning and show when role changed to other and hide otherwise", function () {
        this._initNewsletterSignupDialog("someOtherMail@test.com", "https://www.atlassian.com/newsletter/signup2/{0}");

        var isVisible = this.container.find("#jira-newsletter-other-role-name").is(":visible");
        equal(isVisible, false, "Other role name should be hidden at beginning");

        this.container.find("select[name=jira-newsletter-role]").val("other").change();

        isVisible = this.container.find("#jira-newsletter-other-role-name").is(":visible");
        equal(isVisible, true, "Other role name should show after change to other");

        this.container.find("select[name=jira-newsletter-role]").val("qa").change();

        isVisible = this.container.find("#jira-newsletter-other-role-name").is(":visible");
        equal(isVisible, false, "Other role name should hide after change from other");
    });
});