AJS.test.require(["com.atlassian.jira.jira-header-plugin:newsletter-signup-tip"],function(){var e=require("jquery"),t=require("jira-help-tips/feature/help-tip-manager"),i=require("jira/analytics");require("atlassian/libs/underscore-1.8.3");module("Newsletter render code",{setup:function(){this.newsLetterSignup=require("jira/newsletter/signuptip"),this.container=e("<div>").attr("id","content").appendTo("#qunit-fixture"),this.trigger=e('<div id="user-options"></div>').appendTo("#qunit-fixture"),this.sandbox=sinon.sandbox.create(),this.sandbox.useFakeServer(),this.sandbox.useFakeTimers(),t.dismissedTipIds=[]},teardown:function(){e("body").off("submit","form.aui.insiders-signup-form"),this.sandbox.clock.tick(0),this.sandbox.restore(),this.sandbox.server.restore()},_initNewsletterSignupDialog:function(e,t){this.newsLetterSignup.render({userEmail:e,formUrl:t,signupTitle:"title",signupDescription:"description",signupId:"id"}),this.sandbox.clock.tick(1e4)}}),test("Sign up form is not shown if there are flags visible",function(){var e=AJS.flag();try{this._initNewsletterSignupDialog("test@example.com","https://www.atlassian.com/newsletter/signup"),equal(this.container.find(".jira-help-tip .insiders-signup-form").length,0,"Help tip should not appear when flag is present")}finally{e.close()}}),test("Test e-mail validation",function(){this._initNewsletterSignupDialog("test@example.com","https://www.atlassian.com/newsletter/signup"),this.container.find("input[name=jira-newsletter-user-email]").val("invalidemail!!!"),this.container.find("form.aui.insiders-signup-form").submit(),equal(this.container.find("input[name=jira-newsletter-user-email]").next(".error").text(),"newsletter.signup.tip.error.email","Should have rendered an error about e-mail"),equal(this.sandbox.server.requests.length,0,"Invalid form should not call any request.")}),test("Test opt-in validation",function(){this._initNewsletterSignupDialog("test@example.com","https://www.atlassian.com/newsletter/signup"),this.container.find("input[name=jira-newsletter-user-email]").val("test@email.com"),this.container.find("form.aui.insiders-signup-form").submit(),equal(this.container.find("input[name=jira-newsletter-opt-in]").parent().next(".error").text(),"newsletter.signup.tip.error.opt-in","Should have rendered an error about required opt-in"),equal(this.sandbox.server.requests.length,0,"Invalid form should not call any request.")}),test("Valid e-mail submit triggers cross-domain request to address entered if role selected to qa",function(){this._initNewsletterSignupDialog("valid@email.com","https://www.atlassian.com/newsletter/signup/{0}"),this.container.find("input[name=jira-newsletter-user-email]").val("valid@email.com"),this.container.find("select[name=jira-newsletter-role]").val("qa"),this.container.find("input[name=jira-newsletter-opt-in]").click(),this.container.find("form.aui.insiders-signup-form").submit(),equal(this.sandbox.server.requests[0].method,"POST","Correct request method used"),equal(this.sandbox.server.requests[0].url,"https://www.atlassian.com/newsletter/signup/valid@email.com","Correct url used"),equal(this.sandbox.server.requests[0].requestBody,JSON.stringify({role:"qa",lang:"en"}),"Selected role attached to request")}),test("Valid e-mail submit triggers cross-domain request to address entered if role selected to other",function(){this._initNewsletterSignupDialog("valid@email.com","https://www.atlassian.com/newsletter/signup/{0}"),this.container.find("input[name=jira-newsletter-user-email]").val("valid@email.com"),this.container.find("select[name=jira-newsletter-role]").val("other"),this.container.find("#jira-newsletter-other-role-name").val("role name"),this.container.find("input[name=jira-newsletter-opt-in]").click(),this.container.find("form.aui.insiders-signup-form").submit(),equal(this.sandbox.server.requests[0].method,"POST","Correct request method used"),equal(this.sandbox.server.requests[0].url,"https://www.atlassian.com/newsletter/signup/valid@email.com","Correct url used"),equal(this.sandbox.server.requests[0].requestBody,JSON.stringify({role:"other",otherRoleName:"role name",lang:"en"}),"Selected role attached to request")}),test("Verify if proper analytics were send if selected role is is qa",function(){this.sandbox.server.respondWith("POST","https://www.atlassian.com/newsletter/signup/valid@email.com",[200,{"Content-Type":"application/json"},"{}"]),this.sandbox.server.respondImmediately=!0;var e=this.sandbox.stub(i,"send");this._initNewsletterSignupDialog("valid@email.com","https://www.atlassian.com/newsletter/signup/{0}"),this.container.find("input[name=jira-newsletter-user-email]").val("valid@email.com"),this.container.find("select[name=jira-newsletter-role]").val("qa"),this.container.find("#jira-newsletter-other-role-name").val(""),this.container.find("input[name=jira-newsletter-opt-in]").click(),this.container.find("form.aui.insiders-signup-form").submit(),equal(e.calledWith({name:"jira.newsletter.signuptip.submitted",data:{role:"qa",lang:"en",flagsVisible:0,checksum:sinon.match.number,signupTipDelay:sinon.match.number}}),!0,"Called analytics with proper data")}),test("Verify if proper analytics were send if selected role is other",function(){this.sandbox.server.respondWith("POST","https://www.atlassian.com/newsletter/signup/valid@email.com",[200,{"Content-Type":"application/json"},"{}"]),this.sandbox.server.respondImmediately=!0;var e=this.sandbox.stub(i,"send");this._initNewsletterSignupDialog("valid@email.com","https://www.atlassian.com/newsletter/signup/{0}"),this.container.find("input[name=jira-newsletter-user-email]").val("valid@email.com"),this.container.find("select[name=jira-newsletter-role]").val("other"),this.container.find("#jira-newsletter-other-role-name").val("role name"),this.container.find("input[name=jira-newsletter-opt-in]").click(),this.container.find("form.aui.insiders-signup-form").submit(),equal(e.calledWith({name:"jira.newsletter.signuptip.submitted",data:{role:"other",otherRoleName:"role name",lang:"en",flagsVisible:0,checksum:sinon.match.number,signupTipDelay:sinon.match.number}}),!0,"Called analytics with proper data")}),test("Test description and title rendered correctly",function(){this._initNewsletterSignupDialog("someOtherMail@test.com","https://www.atlassian.com/newsletter/signup2/{0}");var e=this.container.find("h2.helptip-title").text(),t=this.container.find("div>p").text();equal(e,"title","Title rendered correctly"),equal(t,"description","Description rendered correctly")}),test("Test if other role is hidden on beginning and show when role changed to other and hide otherwise",function(){this._initNewsletterSignupDialog("someOtherMail@test.com","https://www.atlassian.com/newsletter/signup2/{0}");var e=this.container.find("#jira-newsletter-other-role-name").is(":visible");equal(e,!1,"Other role name should be hidden at beginning"),this.container.find("select[name=jira-newsletter-role]").val("other").change(),e=this.container.find("#jira-newsletter-other-role-name").is(":visible"),equal(e,!0,"Other role name should show after change to other"),this.container.find("select[name=jira-newsletter-role]").val("qa").change(),e=this.container.find("#jira-newsletter-other-role-name").is(":visible"),equal(e,!1,"Other role name should hide after change from other")})});