define("jira/newsletter/roles", ["jira/util/formatter", "underscore", "exports"], function (formatter, _, exports) {
    "use strict";

    exports.getRoles = function () {
        // this function originates from NPS plugin, forked, because it may diverge
        var prefix = [{
            value: "",
            text: formatter.I18n.getText("newsletter.signup.tip.choose.role"),
            disabled: true,
            selected: true
        }];

        var roles = [{
            value: "software-engineer",
            text: formatter.I18n.getText("nps.survey.inline.dialog.roles.software.engineer")
        }, {
            value: "product-manager",
            text: formatter.I18n.getText("nps.survey.inline.dialog.roles.product.manager")
        }, {
            value: "qa",
            text: formatter.I18n.getText("nps.survey.inline.dialog.roles.qa")
        }, {
            value: "design",
            text: formatter.I18n.getText("nps.survey.inline.dialog.roles.design")
        }, {
            value: "management",
            text: formatter.I18n.getText("nps.survey.inline.dialog.roles.management")
        }, {
            value: "sys-admin",
            text: formatter.I18n.getText("nps.survey.inline.dialog.roles.sys.admin")
        }];

        var suffix = [{
            value: "other",
            text: formatter.I18n.getText("nps.survey.inline.dialog.roles.other")
        }];

        return prefix.concat(_.shuffle(roles)).concat(suffix);
    };
});