/**
 * Adds analytics to the app switcher (hamburger menu in the top left corner). There are events for opening and closing
 * the menu, and an event for clicking on an entry.
 */
define('jira/header/init-app-switcher-analytics', ['jira/analytics', 'jquery'], function (analytics, $) {
    'use strict';

    function initAppSwticherAnalytics(context) {
        var $ctx = $(context);

        // App switcher open.
        $ctx.on('aui-dropdown2-show-before', '#app-switcher', function () {
            analytics.send({
                name: 'navigation.header.appswitcher.open'
            });
        });

        $ctx.on('click', '#app-switcher a, #app-switcher button', function (event) {
            var $el = $(event.target);
            var index = $el.closest("li").index();
            var linkType;

            if ($el.is('.nav-link-edit')) {
                linkType = 'configure';
            } else if ($el.is('.app-discovery-link')) {
                // The id of app-discovery-link is the name of the product, e.g. 'bamboo' or 'confluence'.
                linkType = this.id ? this.id : "unknown.app.discovery";
            } else if ($el.is('.app-discovery-cancel-button')) {
                linkType = 'dont.show';
                // Because of the different DOM structure of the "Don't show this again" button, the method used to
                // calculate the index returns -1, so the index is instead explicitly set to 0.
                index = 0;
            } else {
                linkType = 'application';
            }

            analytics.send({
                name: 'navigation.header.appswitcher.click',
                data: {
                    position: index,
                    linkType: linkType
                }
            });
        });

        // App switcher close.
        $ctx.on('aui-dropdown2-hide', '#app-switcher', function () {
            analytics.send({
                name: 'navigation.header.appswitcher.close'
            });
        });
    }

    return {
        init: initAppSwticherAnalytics
    };
});