define("jira/projects/test-utils/marionettemocker", ['require'], function (require) {
    "use strict";

    var Backbone = require('jira/projectissuenavigator/libs/backbone');
    var _ = require('jira/projectissuenavigator/libs/underscore');

    return {
        /**
         * Creates a generic Backbone/Marionette object with support for events.
         *
         * The mock will have all the {baseClass} and {properties} methods stubbed,
         * and the Backbone.Events methods spied (in other words, only event-related methods
         * will work).
         *
         * Example:
         * ```
         * MarionetteMocker.createEventedMock(sinon, Marionette.Controller, {customMethod: function(){}});
         * ```
         * will return a dummy controller with the same methods than Marionette.Controller plus `customMethod`
         *
         * This method will return an instance, with the property 'constructor' pointing to
         * the constructor of such instance.
         *
         * @param sinon Instance of sinon (or sinon's sandbox) to use for the stubs/spies
         * @param {Object} baseClass Base class to use for this object (eg: Backbone.Collection
         *                           or Marionette.Controller).
         * @param {Object} [properties] List of properties to add to the instance. Can be used to
         *                              "extend" from the base class.
         * @returns {Object} The mocked instance.
         */
        createEventedMock: function(sinon, baseClass, properties) {
            if (typeof baseClass === "function") {
                baseClass = baseClass.prototype;
            }
            var stubbedConstructor = sinon.stub(_.extend({}, baseClass, properties || {}));
            var instance = _.extend({}, stubbedConstructor, Backbone.Events);
            instance.constructor = sinon.spy(function() {
                return instance;
            });
            return instance;
        }


    };
});
