define("jira/projects/test-utils/issue-api-test",["jira/projects/test-utils/projectissuenavigatorworldmocker","jira/projectissuenavigator/services/api","jira/flag","jira/projectissuenavigator/libs/underscore","wrm/data","jquery"],function(c,a,h,j,e,k){var b="com.atlassian.jira.jira-issue-nav-components:inline-edit-enabled";var d=[{id:1,key:"DEMO-1",summary:"The first issue in the project",status:"Open",type:{name:"bug",description:"A bug in your application",icon:"iconUrl.png"}},{id:2,key:"DEMO-2",summary:"The second issue in the project",status:"Open",type:{name:"bug",description:"A bug in your application",icon:"iconUrl.png"}},{id:3,key:"DEMO-3",summary:"The third issue in the project",status:"Open",type:{name:"bug",description:"A bug in your application",icon:"iconUrl.png"}},{id:4,key:"DEMO-4",summary:"The fourth issue in the project",status:"Open",type:{name:"bug",description:"A bug in your application",icon:"iconUrl.png"}}];var g={setup:function(){var l=sinon.sandbox.create();this.world=new c(l);this.oldAPISidebar=JIRA.API.Sidebar;JIRA.API.Sidebar={getAUISidebar:function(){return{}}};k("body").css("overflow-y","auto");a.init()},teardown:function(){this.world.restore();window.onbeforeunload=null;k("body").removeClass("page-type-split").removeClass("page-issue-navigator");JIRA.API.Sidebar=this.oldAPISidebar},setInlineEditParam:function(l){e.claim.withArgs(b).returns(l)},worldWithDefaultData:function(l){return this.world.withData(l||{issue:"DEMO-2",filter:"allissues",issues:d,editableFields:[{id:"summary",editHtml:'<div><input data-id="2" type="text" name="summary"></div>'}]})},loadIssueSearchWithDefaultData:function(l){this.worldWithDefaultData(l).build().waitForIssueSearch()},loadIssueViewWithDefaultData:function(l){this.loadIssueSearchWithDefaultData(l);this.world.goToIssueView().waitForEditor()},assertIsInIssueView:function(){ok(this.world.projectIssueNavigator.issueView);ok(!this.world.projectIssueNavigator.issueSearch)},assertIsInIssueSearch:function(){ok(!this.world.projectIssueNavigator.issueView);ok(this.world.projectIssueNavigator.issueSearch)}};var f=[{enabled:true},{enabled:false},{enabled:undefined}];function i(l){f.forEach(function(m){var n="jira/projectissuenavigator/services/api ["+l.name+", inline edit "+String(m.enabled)+"]";module(n,j.extend({},g,l,{setup:function(){g.setup.call(this);g.setInlineEditParam.call(this,m.enabled)}}));test("JIRA.API.IssueSearch.nextIssue() - It selects the next issue",function(){this.load();JIRA.API.IssueSearch.nextIssue();this.world.waitForPageLoad();this.world.waitForEditor();this.assertComponentIsVisible();this.assertIssueAfterNavigation("DEMO-3")});test("JIRA.API.IssueSearch.nextIssue() - It start recording browser metrics",function(){this.load();JIRA.API.IssueSearch.nextIssue();this.world.waitForPageLoad();this.world.waitForEditor();this.assertComponentIsVisible();this.assertMetricsCalledAfterNavigation(this.world.Metrics.startIssueSearch)});test("JIRA.API.IssueSearch.previousIssue() - It selects the previous issue",function(){this.load();JIRA.API.IssueSearch.previousIssue();this.world.waitForPageLoad();this.world.waitForEditor();this.assertComponentIsVisible();this.assertIssueAfterNavigation("DEMO-1")});test("JIRA.API.IssueSearch.previousIssue() - It start recording browser metrics",function(){this.load();JIRA.API.IssueSearch.previousIssue();this.world.waitForPageLoad();this.world.waitForEditor();this.assertComponentIsVisible();this.assertMetricsCalledAfterNavigation(this.world.Metrics.startIssueSearch)});test("JIRA.API.IssueSearch.getActiveIssueId() - It retrieves the active issue id",function(){this.load();var o=JIRA.API.IssueSearch.getActiveIssueId();this.assertComponentIsVisible();equal(o,2)});test("JIRA.API.IssueSearch.getActiveIssueKey() - It retrieves the active issue key",function(){this.load();var o=JIRA.API.IssueSearch.getActiveIssueKey();this.assertComponentIsVisible();equal(o,"DEMO-2")});test("JIRA.API.IssueSearch.refreshActiveIssue() - It refreshes the active issue",function(){this.load();this.world.withUpdatedIssue("DEMO-2",{summary:"This is the new summary"});JIRA.API.IssueSearch.refreshActiveIssue();this.world.waitForEditor();this.assertComponentIsVisible();equal(this.getSummary(),"This is the new summary")});test("JIRA.API.IssueSearch.refreshActiveIssue() - It returns a promise",function(){this.load();this.world.withUpdatedIssue("DEMO-2",{summary:"This is the new summary"});var o=JIRA.API.IssueSearch.refreshActiveIssue();this.world.waitForEditor();this.assertComponentIsVisible();equal(typeof o.done,"function","It contains the done method");equal(typeof o.fail,"function","It contains the fail method");equal(typeof o.then,"function","It contains the then method");equal(typeof o.always,"function","It contains the always method");equal(typeof o.pipe,"function","It contains the pipe method")});test("JIRA.API.IssueSearch.refreshActiveIssue() - It start recording browser metrics",function(){this.load();this.world.withUpdatedIssue("DEMO-2",{summary:"This is the new summary"});JIRA.API.IssueSearch.refreshActiveIssue();this.world.waitForEditor();this.assertComponentIsVisible();this.assertMetricsCalledAfterNavigation(this.getBrowserMetricsFunction())});test("JIRA.API.IssueSearch.refreshIssue() - It refreshes any issue based on the issueId",function(){this.load();this.world.withUpdatedIssue("DEMO-2",{summary:"This is the new summary"});JIRA.API.IssueSearch.refreshIssue(2);this.world.waitForEditor();this.assertComponentIsVisible();equal(this.getSummary(),"This is the new summary")});test("JIRA.API.IssueSearch.refreshIssue() - It returns a promise",function(){this.load();this.world.withUpdatedIssue("DEMO-2",{summary:"This is the new summary"});var o=JIRA.API.IssueSearch.refreshIssue(2);this.world.waitForEditor();this.assertComponentIsVisible();equal(typeof o.done,"function","It contains the done method");equal(typeof o.fail,"function","It contains the fail method");equal(typeof o.then,"function","It contains the then method");equal(typeof o.always,"function","It contains the always method");equal(typeof o.pipe,"function","It contains the pipe method")});test("JIRA.API.IssueSearch.refreshIssue() - It start recording browser metrics",function(){this.load();this.world.withUpdatedIssue("DEMO-2",{summary:"This is the new summary"});this.world.Metrics.startIssueSearch.reset();JIRA.API.IssueSearch.refreshIssue(2);this.world.waitForEditor();this.assertComponentIsVisible();this.assertMetricsCalledAfterNavigation(this.getBrowserMetricsFunction())});test("JIRA.API.IssueSearch.editField() - It edits a field in the active issue",function(){this.load();this.world.waitForEditorFields();JIRA.API.IssueSearch.editField("summary");this.assertComponentIsVisible();ok(this.world.dialogEl.indexOf("<div><input data-id='2' type='text' name='summary'/></div>">-1))});test("JIRA.API.IssueSearch.getFields() - It get the fields from the active issue",function(){this.load();this.world.waitForEditorFields();var o=JIRA.API.IssueSearch.getFields();this.assertComponentIsVisible();equal(o.length,1);equal(k(o.get("summary").get("editHtml")).find("input[data-id=2][type=text][name=summary]").length,1)});test("JIRA.API.IssueSearch.isSaving() - It detects when there are saves in progress",function(){this.load();this.world.waitForEditorFields();var o=JIRA.API.IssueSearch.getFields();o.get("summary").edit();o.get("summary").save();this.assertComponentIsVisible();ok(JIRA.API.IssueSearch.isSaving())});test("JIRA.API.IssueSearch.isLoading() - It detects when the IssueEditor is loading",function(){this.startLoading();ok(JIRA.API.IssueSearch.isLoading());this.world.waitForEditor();this.assertComponentIsVisible();ok(!JIRA.API.IssueSearch.isLoading())});test("JIRA.API.IssueSearch.hasAccessibleIssue() - It detects if there is an issue loaded when there are results",function(){this.load();this.world.waitForEditor();this.assertComponentIsVisible();ok(JIRA.API.IssueSearch.hasAccessibleIssue())});test("JIRA.API.IssueSearch.hasAccessibleIssue() - It detects that there is not an issue loaded when there are no results",function(){this.load({issue:"DEMO-2",filter:"allissues",issues:[]});ok(!JIRA.API.IssueSearch.hasAccessibleIssue())});test("JIRA.API.IssueSearch.hasAccessibleIssue() - It detects that there is not an issue loaded when the issue has been deleted",function(){this.load();this.world.withUpdatedIssue("DEMO-2",{inaccessible:true});this.assertComponentIsVisible();JIRA.API.IssueSearch.refreshActiveIssue();this.world.waitForEditor();this.assertComponentIsVisible();ok(!JIRA.API.IssueSearch.hasAccessibleIssue())});test("JIRA.API.IssueSearch.showLoadError() - It shows the 'loading error' flag",function(){this.load();JIRA.API.IssueSearch.showLoadError();this.assertComponentIsVisible();sinon.assert.calledOnce(this.world.JIRAFlag.showErrorMsg);equal(this.world.JIRAFlag.showErrorMsg.lastCall.args[0],"","Title");equal(this.world.JIRAFlag.showErrorMsg.lastCall.args[1],JIRA.Components.IssueViewer.Templates.Body.errorsLoading(),"Body")});test("JIRA.API.IssueSearch.waitForSavesToComplete() - It waits for saves to complete using a promise, resolved if there are no pending saves",function(){this.load();var o=this.spy();JIRA.API.IssueSearch.waitForSavesToComplete().done(o);this.assertComponentIsVisible();sinon.assert.calledOnce(o)});test("JIRA.API.IssueSearch.waitForSavesToComplete() -  It waits for saves to complete using a promise, resolved when all the saves are completed",function(){this.load();this.world.waitForEditorFields();var p=this.spy();var o=JIRA.API.IssueSearch.getFields();o.get("summary").edit();o.get("summary").save();JIRA.API.IssueSearch.waitForSavesToComplete().done(p);this.assertComponentIsVisible();sinon.assert.notCalled(p);this.world.waitForEditorSave();this.assertComponentIsVisible();sinon.assert.calledOnce(p)});test("JIRA.API.IssueSearch.focusSearch() - Does nothing",function(){this.load();JIRA.API.IssueSearch.focusSearch();this.assertComponentIsVisible()});test("JIRA.API.IssueSearch.toggleFilterPanel() - Does nothing",function(){this.load();JIRA.API.IssueSearch.toggleFilterPanel();this.assertComponentIsVisible()});test("JIRA.API.IssueSearch.isQueryValid() - All queries are valid",function(){this.load();this.assertComponentIsVisible();ok(JIRA.API.IssueSearch.isQueryValid())});test("JIRA.API.IssueSearch.isFullScreenIssueVisible() - It detects if it is in IssueView mode",function(){this.load();this.assertComponentIsVisible();this.assertFullScreenIssueVisible()});test("JIRA.API.IssueSearch.switchLayouts() in IssueSearch - It does nothing",function(){this.load();JIRA.API.IssueSearch.switchLayouts();this.assertComponentIsVisible()});test("JIRA.API.IssueSearch.openFocusShifter() in IssueSearch - It opens the focus shifter",function(){this.load();JIRA.API.IssueSearch.openFocusShifter();this.assertComponentIsVisible();sinon.assert.calledOnce(this.world.FocusShifter.prototype.show)})})}return{issuesFixture:d,baseModuleConfiguration:g,makeTestsForComponent:i}});