AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test",function(){require(["jira/projectissuenavigator/services/browser","jira/projectissuenavigator/services/router","jira/projectissuenavigator/services/urlhelper","jira/projectissuenavigator/libs/backbone","jira/projects/test-utils/mockutils","jira/util/data/meta","wrm/context-path"],function(h,a,e,g,f,c,b){var d="http://localhost:2990"+b();module("jira/projectissuenavigator/services/router",{setup:function(){this.sandbox=sinon.sandbox.create();this.mockHistory();this.meta=c;this.urlHelper=e;this.browser=h;this.sandbox.stub(this.browser,"getCurrentUrl").returns("http://localhost:2990"+b()+"/projects/DEMO/issues");this.sandbox.stub(g.history,"start");this.sandbox.stub(g.Router.prototype,"navigate");this.sandbox.stub(this.meta,"get").withArgs("jira-base-url").returns(d);this.sandbox.stub(this.meta,"set");this.RouterConstructor=f.requireWithMocks("jira/projectissuenavigator/services/router",{"jira/projectissuenavigator/services/browser":this.browser,"jira/projectissuenavigator/services/urlhelper":this.urlHelper,"jira/util/data/meta":this.meta});this.router=new this.RouterConstructor()},teardown:function(){this.sandbox.restore()},mockHistory:function(){this.history=window.history||{pushState:function(){}};this.sandbox.stub(this.history,"pushState")},simulateNavigation:function(j){var i=b()+"/projects/DEMO/issues"+j;this.browser.getCurrentUrl.returns(i);g.history.loadUrl(j,{trigger:true})}});test("When starting, it transforms a pushState URL into a non-pushState URL if the browser does not support pushState",function(){this.stub(this.urlHelper,"getApplicationUrl").returns("/DEMO-123?filter=myfilter");this.stub(this.browser,"hasPushState").returns(false);this.stub(this.browser,"locationReplace");this.router.start();sinon.assert.calledOnce(this.browser.locationReplace);sinon.assert.calledWith(this.browser.locationReplace,b()+"/projects/DEMO/issues#DEMO-123?filter=myfilter")});test("When starting, it does not transform the pushState URL if the browser already supports pushState ",function(){this.stub(this.urlHelper,"getApplicationUrl").returns("/DEMO-123?filter=myfilter");this.stub(this.browser,"hasPushState").returns(true);this.stub(this.browser,"locationReplace");this.router.start();sinon.assert.notCalled(this.browser.locationReplace)});test("When starting, it does not transform a non-pushState URL",function(){this.stub(this.urlHelper,"getApplicationUrl").returns("#DEMO-123?filter=myfilter");this.stub(this.browser,"locationReplace");this.router.start();sinon.assert.notCalled(this.browser.locationReplace)});test("When going to an URL, it does a full page reload with the correct URL",function(){this.stub(this.browser,"locationAssign");this.router.goTo({project:"NEWPROJECT",issue:"NP-123",filter:"allissues",orderby:"key DESC"});sinon.assert.calledOnce(this.browser.locationAssign);sinon.assert.calledWith(this.browser.locationAssign,b()+"/projects/NEWPROJECT/issues/NP-123?filter=allissues&orderby=key+DESC")});test("When updating the URL, it does not a full page reload",function(){this.stub(this.browser,"locationAssign");this.router.updateURL({issue:"DEMO-1"});sinon.assert.notCalled(this.browser.locationAssign)});test("When updating the URL, it does nothing if the new URL matches the current browser URL",function(){this.stub(this.browser,"locationAssign");this.browser.getCurrentUrl.returns(b()+"/projects/DEMO/issues/DEMO-1?filter=allissues&orderby=key+DESC");this.router.updateURL({issue:"DEMO-1",project:"DEMO",filter:"allissues",orderby:"key DESC"});sinon.assert.notCalled(g.Router.prototype.navigate)});test("When updating the URL, it uses the router navigation to update it without triggering the route matching",function(){this.router.updateURL({issue:"DEMO-1"});sinon.assert.calledOnce(g.Router.prototype.navigate);deepEqual(g.Router.prototype.navigate.firstCall.args[1],{trigger:false,replace:false})});test("When updating the URL with the replace flag set, it replaces the browser history",function(){this.router.updateURL({issue:"DEMO-1",replaceHistory:true});deepEqual(g.Router.prototype.navigate.firstCall.args[1],{trigger:false,replace:true})});test("When updating the URL with the keepParameters flag set, it carries over the parameters from the current URL",function(){this.browser.getCurrentUrl.returns("http://localhost:2990/jira/browse/DEMO-1?focusedCommentId=123&page=some-page&filter=some-rogue-filter#comment-123");this.router.updateURL({issue:"DEMO-1",project:"DEMO",filter:"allissues",orderby:"key DESC",keepParameters:true});sinon.assert.calledWith(g.Router.prototype.navigate,b()+"/projects/DEMO/issues/DEMO-1?focusedCommentId=123&page=some-page&filter=allissues&orderby=key+DESC#comment-123")});test("When updating the URL, it uses the provided options to generate the new URL",function(){this.router.updateURL({issue:"DEMO-1",project:"DEMO",filter:"allissues",orderby:"key DESC"});sinon.assert.calledWith(g.Router.prototype.navigate,b()+"/projects/DEMO/issues/DEMO-1?filter=allissues&orderby=key+DESC")});test("When updating the URL, it also updates the permalink state",function(){this.router.updateURL({issue:"DEMO-1",filter:"allissues",orderby:"key DESC"});sinon.assert.calledWith(this.meta.set,"viewissue-permlink",d+"/browse/DEMO-1")});test("When updating the URL, it also updates the permalink state when no context path is set",function(){this.meta.get.withArgs("jira-base-url").returns("http://localhost:2990/");this.router.updateURL({issue:"DEMO-1",filter:"allissues",orderby:"key DESC"});sinon.assert.calledWith(this.meta.set,"viewissue-permlink","http://localhost:2990/browse/DEMO-1")});test("When the browser loads /browse/KEY for the first time, the router triggers the 'route:browse:initial' event",function(){var i=this.spy();this.router.on("route:browse:initial",i);this.simulateNavigation("/browse/DEMO-1");sinon.assert.calledOnce(i)});test("When the browser loads /browse/KEY for the second time, the router triggers the 'route:browse' event",function(){this.simulateNavigation("/browse/DEMO-1");var i=this.spy();this.router.on("route:browse",i);this.simulateNavigation("/browse/DEMO-2");sinon.assert.calledOnce(i)});test("When the browser loads /browse/KEY, the event contains the URL parts",function(){var i=this.spy();this.router.on("route:browse:initial",i);this.simulateNavigation("/browse/DEMO-1?filter=openissues&orderby=key+DESC&startIndex=3");sinon.assert.calledWith(i,sinon.match({issue:"DEMO-1",filter:"openissues",orderby:"key DESC",startIndex:"3"}))});test("When the browser loads /projects/DEMO/issues/KEY for the first time, the router triggers the 'route:issues:initial' event",function(){var i=this.spy();this.router.on("route:issues:initial",i);this.simulateNavigation("/projects/DEMO/issues/DEMO-1");sinon.assert.calledOnce(i)});test("When the browser loads /projects/DEMO/issues/KEY for the second time, the router triggers the 'route:issues' event",function(){this.simulateNavigation("/projects/DEMO/issues/DEMO-1");var i=this.spy();this.router.on("route:issues",i);this.simulateNavigation("/projects/DEMO/issues/DEMO-2");sinon.assert.calledOnce(i)});test("When the browser loads /projects/DEMO/issues/KEY, the event contains the URL parts",function(){var i=this.spy();this.router.on("route:issues:initial",i);this.simulateNavigation("/projects/DEMO/issues/DEMO-1?filter=openissues&orderby=key+DESC&startIndex=3");sinon.assert.calledWith(i,sinon.match({issue:"DEMO-1",filter:"openissues",orderby:"key DESC",startIndex:"3"}))})})});