AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test", function() {
    "use strict";

    require([
        "jira/projectissuenavigator/services/keyboardshortcuts",
        "jira/projectissuenavigator/services/browser",
        "jira/ajs/keyboardshortcut/keyboard-shortcut-toggle",
        "jquery"
    ], function(
        KeyboardShortcuts,
        Browser,
        KeyboardShortcutsToggle,
        jQuery
    ) {
        module("jira/projectissuenavigator/services/keyboardshortcuts", {
            setup: function () {
                this.sandbox = sinon.sandbox.create();

                this.document = jQuery("<div/>");
                this.sandbox.stub(Browser, "getDocument").returns(this.document);
                this.sandbox.stub(KeyboardShortcutsToggle, "areKeyboardShortcutsDisabled").returns(false);

                this.keyboardShortcuts = new KeyboardShortcuts();
            },

            teardown: function () {
                this.sandbox.restore();
            },


            simulateKeyPress: function(key) {
                var press = new jQuery.Event("keydown");
                press.which = key;
                this.document.trigger(press);
            },

            onEvent: function(event) {
                var eventHandler = this.spy();
                this.keyboardShortcuts.on(event, eventHandler);
                return eventHandler;
            }
    });

        test("When the LEFT key is pressed, it triggers the 'focusIssueList' event", function() {
            var onFocusIssueList = this.onEvent('focusIssueList');

            this.simulateKeyPress(jQuery.ui.keyCode.LEFT);

            sinon.assert.calledOnce(onFocusIssueList);
        });

        test("When the RIGHT key is pressed, it triggers the 'focusIssueEditor' event", function() {
            var onFocusIssueEditor = this.onEvent('focusIssueEditor');

            this.simulateKeyPress(jQuery.ui.keyCode.RIGHT);

            sinon.assert.calledOnce(onFocusIssueEditor);
        });

        test("When another key is pressed, it doesn't trigger anything", function() {
            var onFocusIssueList = this.onEvent('focusIssueList');
            var onFocusIssueEditor = this.onEvent('focusIssueEditor');

            this.simulateKeyPress(jQuery.ui.keyCode.UP);

            sinon.assert.notCalled(onFocusIssueList);
            sinon.assert.notCalled(onFocusIssueEditor);
        });

        test("When the keyboard shortcuts are disabled, it doesn't trigger anything", function() {
            var onFocusIssueList = this.onEvent('focusIssueList');
            var onFocusIssueEditor = this.onEvent('focusIssueEditor');
            KeyboardShortcutsToggle.areKeyboardShortcutsDisabled.returns(true);

            this.simulateKeyPress(jQuery.ui.keyCode.LEFT);

            sinon.assert.notCalled(onFocusIssueList);
            sinon.assert.notCalled(onFocusIssueEditor);
        });

        test("When there is a dialog in the page, it doesn't trigger anything", function() {
            this.document.append("<div class='aui-blanket'/>");
            var onFocusIssueList = this.onEvent('focusIssueList');
            var onFocusIssueEditor = this.onEvent('focusIssueEditor');

            this.simulateKeyPress(jQuery.ui.keyCode.LEFT);

            sinon.assert.notCalled(onFocusIssueList);
            sinon.assert.notCalled(onFocusIssueEditor);
        });
    });
});
