AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test", function() {
    "use strict";

    var BaseApiTest = require("jira/projects/test-utils/issue-api-test");

    BaseApiTest.makeTestsForComponent({
        name: 'IssueView',
        load: function(data) {
            this.loadIssueViewWithDefaultData(data);
        },
        startLoading: function() {
            this.loadIssueSearchWithDefaultData();
            this.world
                .goToIssueView()
                .waitForEditorToStartLoading();
        },
        assertComponentIsVisible: function() {
            this.assertIsInIssueView();
        },
        getSummary: function() {
            return this.world.projectIssueNavigator.issueView.issueComponent.model.get('entity').summary;
        },
        getBrowserMetricsFunction: function() {
            return this.world.Metrics.startIssueView;
        },
        assertFullScreenIssueVisible: function() {
            ok(JIRA.API.IssueSearch.isFullScreenIssueVisible());
        },
        assertIssueAfterNavigation: function(issue) {
            equal(JIRA.API.IssueSearch.getActiveIssueKey(), issue);
        },
        assertMetricsCalledAfterNavigation: function(metricsFunction) {
            sinon.assert.calledOnce(metricsFunction);
        }
    });
});
