AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test", function() {
    "use strict";

    var BaseApiTest = require("jira/projects/test-utils/issue-api-test");

    var ISSUES = BaseApiTest.issuesFixture;

    BaseApiTest.makeTestsForComponent({
        name: 'IssueSearch',
        load: function(data) {
            this.loadIssueSearchWithDefaultData(data);
        },
        startLoading: function() {
            this.world
                .withData({
                    issue: 'DEMO-2',
                    filter: 'allissues',
                    issues: ISSUES
                })
                .build()
                .waitForSearch()
                .waitForPageLoad()
                .waitForEditorToStartLoading();
        },
        assertComponentIsVisible: function() {
            this.assertIsInIssueSearch();
        },
        getSummary: function() {
            return this.world.projectIssueNavigator.issueSearch.detailsLayout.searchResults.get(2).get("summary");
        },
        getBrowserMetricsFunction: function() {
            return this.world.Metrics.startIssueSearch;
        },
        assertFullScreenIssueVisible: function() {
            ok(!JIRA.API.IssueSearch.isFullScreenIssueVisible());
        },
        assertIssueAfterNavigation: function(issue) {
            equal(JIRA.API.IssueSearch.getActiveIssueKey(), issue);
        },
        assertMetricsCalledAfterNavigation: function(metricsFunction) {
            sinon.assert.calledOnce(metricsFunction);
        }
    });
});
