define("jira/projectissuenavigator/services/focusshifter", ["require"], function(require) {
    "use strict";

    var Marionette = require("jira/projectissuenavigator/libs/marionette");
    var jQuery = require("jquery");
    var _ = require("jira/projectissuenavigator/libs/underscore");
    var Shifter = require('jira/shifter');

    function generateFieldSuggestions(fields) {
        return _
            .chain(fields.models)
            .filter(function(field) {
                return field.id !== 'comment' && field.isEditable();
            })
            .map(function(field) {
                return {
                    label: field.getLabel(),
                    value: field.id
                };
            })
            .value();
    }

    function generateFocusShifterSuggestionsProvider(issueEditor) {
        return function() {
            var fields = issueEditor.getFields();
            var suggestions = fields ? generateFieldSuggestions(fields) : [];

            return {
                id: 'edit-fields',
                name: AJS.I18n.getText('shifter.group.editfields'),
                context: issueEditor.getIssueKey(),
                weight: 100,
                getSuggestions: function() {
                    return new jQuery.Deferred().resolve(suggestions);
                },
                onSelection: function(fieldId) {
                    var field = issueEditor.getFields().get(fieldId);
                    issueEditor.editField(field);
                }
            };
        };
    }

    return Marionette.Object.extend({
        initialize: function(issueEditor) {
            this.provider = generateFocusShifterSuggestionsProvider(issueEditor);
            Shifter.register(this.provider);
        },

        onDestroy: function() {
            Shifter.unregister(this.provider);
        },

        show: function() {
            Shifter.show();
        }
    });
});
