AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test",function(){require(["jira/projectissuenavigator/services/filters","jira/projectissuenavigator/libs/underscore","jira/util/data/meta","wrm/data"],function(j,k,a,d){var l="com.atlassian.jira.jira-projects-issue-navigator:project-filters";var i="com.atlassian.jira.jira-projects-issue-navigator:can-manage-filters";var b="com.atlassian.jira.jira-projects-issue-navigator:generic-filters";var f="com.atlassian.jira.jira-projects-issue-navigator:default-filter-priority";var e=["allissues","myopenissues","allopenissues","reportedbyme","addedrecently","resolvedrecently","updatedrecently","recentlyviewed","doneissues"];var h={allissues:'project = "DEMO" ORDER BY priority DESC, updated DESC',myopenissues:'project = "DEMO" AND assignee = currentUser() AND resolution = Unresolved ORDER BY priority DESC, updated DESC',allopenissues:'project = "DEMO" AND resolution = Unresolved ORDER BY priority DESC, updated DESC',reportedbyme:'project = "DEMO" AND reporter = currentUser() ORDER BY created DESC',addedrecently:'project = "DEMO" AND created >= -1w ORDER BY created DESC',resolvedrecently:'project = "DEMO" AND resolutiondate >= -1w ORDER BY updated DESC',updatedrecently:'project = "DEMO" AND updated >= -1w ORDER BY updated DESC',recentlyviewed:'project = "DEMO" AND issuekey in issueHistory() ORDER BY lastViewed DESC',doneissues:'project = "DEMO" AND statusCategory = Done ORDER BY updated DESC'};var g=[{id:"allissues",jql:'project = "{0}" ORDER BY {1}',defaultOrderby:"priority DESC, updated DESC",label:AJS.I18n.getText("common.filters.all"),requiresUser:false,fields:[],supportsInlineIssueCreate:true},{id:"myopenissues",jql:'project = "{0}" AND assignee = currentUser() AND resolution = Unresolved ORDER BY {1}',defaultOrderby:"priority DESC, updated DESC",label:AJS.I18n.getText("issue.nav.filters.my.open.issues"),requiresUser:true,fields:["assignee","resolution"],supportsInlineIssueCreate:true},{id:"allopenissues",jql:'project = "{0}" AND resolution = Unresolved ORDER BY {1}',defaultOrderby:"priority DESC, updated DESC",label:AJS.I18n.getText("issue.nav.filters.open.issues"),fields:["resolution"],supportsInlineIssueCreate:true},{id:"reportedbyme",jql:'project = "{0}" AND reporter = currentUser() ORDER BY {1}',defaultOrderby:"created DESC",label:AJS.I18n.getText("common.filters.reportedbyme"),requiresUser:true,fields:["reporter"],supportsInlineIssueCreate:true},{id:"addedrecently",jql:'project = "{0}" AND created >= -1w ORDER BY {1}',defaultOrderby:"created DESC",label:AJS.I18n.getText("issue.nav.filters.created.recently"),fields:["created"],supportsInlineIssueCreate:true},{id:"resolvedrecently",jql:'project = "{0}" AND resolutiondate >= -1w ORDER BY {1}',defaultOrderby:"updated DESC",label:AJS.I18n.getText("common.filters.resolvedrecently"),fields:["resolutiondate"]},{id:"updatedrecently",jql:'project = "{0}" AND updated >= -1w ORDER BY {1}',defaultOrderby:"updated DESC",label:AJS.I18n.getText("common.filters.updatedrecently"),fields:["updated"],supportsInlineIssueCreate:true},{id:"recentlyviewed",jql:'project = "{0}" AND issuekey in issueHistory() ORDER BY {1}',defaultOrderby:"lastViewed DESC",label:AJS.I18n.getText("issue.nav.filters.recently.viewed"),fields:["issuekey"],supportsInlineIssueCreate:true},{id:"doneissues",jql:'project = "{0}" AND statusCategory = Done ORDER BY {1}',defaultOrderby:"updated DESC",label:AJS.I18n.getText("issue.nav.filters.done.issues"),fields:["statusCategory"],supportsInlineIssueCreate:false}];var c=[{id:"filter1",jql:'project = "{0}" ORDER BY {1}',defaultOrderby:"priority DESC, updated DESC",label:"Filter 1",requiresUser:true},{id:"filter2",jql:'project = "{0}" ORDER BY {1}',defaultOrderby:"priority DESC, updated DESC",label:"Filter 2",requiresUser:false}];module("jira/projectissuenavigator/services/filters",{setup:function(){this.sandbox=sinon.sandbox.create();this.sandbox.stub(a,"get");this.sandbox.stub(d,"claim");d.claim.withArgs(f).returns(["allopenissues","allissues"]);d.claim.withArgs(b).returns(g)},teardown:function(){this.sandbox.restore()},withFilters:function(n){var m=d.claim;m.withArgs(i).returns(n);m.withArgs(l).returns(c)}});test("It provides the list of default filters",function(){j.initialize();deepEqual(k.pluck(j.getAvailableFilters()[0],"id"),e)});test("It provides a link to Manage Filters if there are project filters",function(){this.withFilters(true);j.initialize();deepEqual(k.pluck(j.getAvailableFilters(true)[2],"id"),["manage"])});test("It doesn't provide a link to Manage Filters if the current user can't manage them",function(){this.withFilters(false);j.initialize();deepEqual(k.pluck(j.getAvailableFilters(true)[2],"id"),[])});test("It does not provides a link to Manage Filters if there are not project filters",function(){d.claim.withArgs(l).returns(undefined);j.initialize();equal(j.getAvailableFilters(true).length,1)});test("It provides the 'all' filter",function(){j.initialize();equal(j.getAllIssuesFilterId(),"allissues")});test("It provides the JQL for each filter with the default order by",function(){j.initialize();k.each(e,function(n){var m=j.getJQL(n,"DEMO");equal(m,h[n],"JQL for "+n)})});test("It provides the JQL for each filter with a custom order by",function(){j.initialize();k.each(e,function(n){var m=j.getJQL(n,"DEMO","key DESC");var o={allissues:'project = "DEMO" ORDER BY key DESC',myopenissues:'project = "DEMO" AND assignee = currentUser() AND resolution = Unresolved ORDER BY key DESC',allopenissues:'project = "DEMO" AND resolution = Unresolved ORDER BY key DESC',reportedbyme:'project = "DEMO" AND reporter = currentUser() ORDER BY key DESC',addedrecently:'project = "DEMO" AND created >= -1w ORDER BY key DESC',resolvedrecently:'project = "DEMO" AND resolutiondate >= -1w ORDER BY key DESC',updatedrecently:'project = "DEMO" AND updated >= -1w ORDER BY key DESC',recentlyviewed:'project = "DEMO" AND issuekey in issueHistory() ORDER BY key DESC',doneissues:'project = "DEMO" AND statusCategory = Done ORDER BY key DESC'};equal(m,o[n],"JQL for "+n)})});test("It escapes the project key by using quotes in the JQL",function(){j.initialize();var m=j.getJQL("allissues","IN");equal(m,'project = "IN" ORDER BY priority DESC, updated DESC')});test("It checks if a filter can be refreshed when a new issue is created using Inline Issue Create",function(){this.withFilters(false);j.initialize();equal(j.filterSupportsInlineIssueCreate("allissues"),true);equal(j.filterSupportsInlineIssueCreate("myopenissues"),true);equal(j.filterSupportsInlineIssueCreate("allopenissues"),true);equal(j.filterSupportsInlineIssueCreate("reportedbyme"),true);equal(j.filterSupportsInlineIssueCreate("addedrecently"),true);equal(j.filterSupportsInlineIssueCreate("resolvedrecently"),false);equal(j.filterSupportsInlineIssueCreate("updatedrecently"),true);equal(j.filterSupportsInlineIssueCreate("recentlyviewed"),true);equal(j.filterSupportsInlineIssueCreate("doneissues"),false);equal(j.filterSupportsInlineIssueCreate("unknownfilter"),false);equal(j.filterSupportsInlineIssueCreate("filter2"),false)});test("It provides a sensible defaultFilterId when no hidden field is in the query",function(){j.initialize();equal(j.getDefaultFilterId(),"allopenissues")});test("It provides a sensible defaultFilterId when there are some filters hidden",function(){d.claim.withArgs(b).returns(k.filter(g,function(m){return m.id!=="allopenissues"}));j.initialize();equal(j.getDefaultFilterId(),"allissues")})})});