define("jira/projectissuenavigator/services/browser", function() {
    "use strict";

    return {
        /**
         * @returns {string} The full URL in the address bar, e.g. http://localhost:2990/jira/browse/KEY-1?jql=
         */
        getCurrentUrl: function() {
            return document.location.href;
        },

        hasPushState: function() {
            return !!(window.history && window.history.pushState);
        },

        locationReplace: function(url) {
            return window.location.replace(url);
        },

        locationAssign: function(url) {
            return window.location.assign(url);
        },

        getDocument: function() {
            return document;
        },

        scrollIntoView: function (id) {
            var element = document.getElementById(id);
            if (element) {
                element.scrollIntoView();
            }
        }
    };
});
