AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test", function() {
    "use strict";

    var BaseApiTest = require("jira/projects/test-utils/issue-api-test");

    BaseApiTest.makeTestsForComponent({
        name: 'IssueView (via /browse/ URL)',
        load: function(data) {
            this.worldWithDefaultData(data)
                .usingBrowseUrl()
                .build()
                .waitForEditor();
        },
        startLoading: function() {
            this.worldWithDefaultData()
                .usingBrowseUrl()
                .build()
                .waitForEditorToStartLoading();
        },
        assertComponentIsVisible: function() {
            this.assertIsInIssueView();
        },
        getSummary: function() {
            return this.world.projectIssueNavigator.issueView.issueComponent.model.get('entity').summary;
        },
        getBrowserMetricsFunction: function() {
            return this.world.Metrics.startIssueView;
        },
        assertFullScreenIssueVisible: function() {
            ok(JIRA.API.IssueSearch.isFullScreenIssueVisible());
        },
        assertIssueAfterNavigation: function() {
        },
        assertMetricsCalledAfterNavigation: function() {
        }
    });
});
