AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test", function () {
    "use strict";

    var IssueView = require("jira/projectissuenavigator/pages/issueview/views/issue");

    module("jira/projectissuenavigator/pages/issueview/views/issue", {
        setup: function() {
            this.view = new IssueView({
                showCollapse: true
            });
        },

        getTipsy: function(view) {
            // This hack is horrible, but Tipsy makes a good job in not exposing its internal implementation.
            // If we want to assert things on the Tipsy, we need to spy on its methods.

            // This forces the creation of the tipsy
            this.showTipsy(view);
            view.ui.collapse.trigger('hide');

            // Get the Tipsy instance
            return view.ui.collapse.data('tipsy');
        },

        showTipsy: function(view) {
            view.ui.collapse.trigger('mouseover');
        }
    });

    test("When the view is destroyed, it destroys the tooltip for the Collapse button", function() {
        this.view.render();
        var tipsy = this.getTipsy(this.view);
        var onHide = this.spy(tipsy, "hide");

        this.showTipsy(this.view);
        this.view.destroy();

        sinon.assert.calledOnce(onHide);
    });
});
