define("jira/projectissuenavigator/pages/issuesearch/views/empty", [
    'require'
], function (
    require
) {
    "use strict";

    var Marionette = require('jira/projectissuenavigator/libs/marionette');
    var Templates = require("jira/projectissuenavigator/pages/issuesearch/templates");

    return Marionette.LayoutView.extend({
        initialize: function() {
            this.content = this.options.emptyViewContent || Templates.defaultEmptyState();
        },

        template: Templates.emptyState,

        regions: {
            inlineIssueCreateContainer: '.inline-issue-create-container'
        },

        serializeData: function() {
            return {
                content: this.content
            };
        },

        onRender: function () {
            this.unwrapTemplate();
        }
    });
});
