AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test", function() {
    "use strict";

    require([
        "jira/projectissuenavigator/pages/issuesearch/views/empty",
        "jquery"
    ], function(
        EmptyView,
        jQuery
    ) {
        var Templates = require("jira/projectissuenavigator/pages/issuesearch/templates");

        module("jira/projectissuenavigator/pages/issuesearch/views/empty", {
            setup: function() {
            },

            buildView: function(options) {
                return new EmptyView(options);
            }
        });

        test("By default, it renders the 'JIRA.Issues.Projects.Templates.defaultEmptyState' template inside the view", function() {
            var view = this.buildView();

            view.render();

            ok(jQuery.contains(view.$el, jQuery(Templates.defaultEmptyState())));
        });

        test("It renders the provied content inside the view", function() {
            var customContent = '<pre>something</pre>';
            var view = this.buildView({
                emptyViewContent: customContent
            });

            view.render();

            ok(jQuery.contains(view.$el, jQuery(customContent)));
        });
    });
});
