AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test",function(){require(["jira/components/search","jira/projectissuenavigator/libs/marionette","jira/projectissuenavigator/services/filters","jira/projectissuenavigator/services/urlhelper","jira/projectissuenavigator/services/linkscapturer","jira/projectissuenavigator/libs/uri","jira/projectissuenavigator/services/browser","jira/projectissuenavigator/services/dialogsoverrider","jira/projectissuenavigator/services/metrics","jira/projectissuenavigator/pages/issuesearch/views/empty","jira/components/detailslayout","jira/components/search/results","jira/projectissuenavigator/services/inline-issue-create","jira/util/events","jira/projects/test-utils/marionettemocker","jira/projects/test-utils/mockutils","jira/flag","jira/message","jira/projectissuenavigator/libs/backbone","jquery","jira/projectissuenavigator/libs/underscore","jira/ajs/ajax/smart-ajax","jira/projectissuenavigator/entities/navigatorstate","jira/components/util/events"],function(l,k,y,n,e,m,b,f,h,q,r,g,t,d,u,j,i,a,c,p,x,v,o,s){var w=JIRA.Projects.Subnavigator;module("jira/projectissuenavigator/pages/issuesearch",{setup:function(){this.sandbox=sinon.sandbox.create();this.sandbox.useFakeServer();this.sandbox.stub(c.history,"start");this.sandbox.stub(b,"locationAssign");this.sandbox.stub(n,"extractProjectKeyFromCurrentUrl").returns("DEMO");this.detailsLayout=u.createEventedMock(this.sandbox,r);this.subnavigator=u.createEventedMock(this.sandbox,w);this.linksCapturer=u.createEventedMock(this.sandbox,e);this.inlineIssueCreate=u.createEventedMock(this.sandbox,t);this.emptyView=u.createEventedMock(this.sandbox,q);this.dialogsOverrider=u.createEventedMock(this.sandbox,f);this.sandbox.stub(y,"getJQL");JIRA.Projects.Subnavigator=this.subnavigator.constructor;this.IssueSearchConstructor=j.spyAll(this.sandbox,j.requireWithMocks("jira/projectissuenavigator/pages/issuesearch",{"jira/components/detailslayout":this.detailsLayout.constructor,"jira/projectissuenavigator/services/urlhelper":n,"jira/projectissuenavigator/services/linkscapturer":this.linksCapturer.constructor,"jira/projectissuenavigator/services/browser":b,"jira/projectissuenavigator/pages/issuesearch/views/empty":this.emptyView.constructor,"jira/projectissuenavigator/services/dialogsoverrider":this.dialogsOverrider.constructor,"jira/util/events":d,"jira/projectissuenavigator/services/metrics":h,"jira/ajs/ajax/smart-ajax":v,"jira/projectissuenavigator/services/inline-issue-create":this.inlineIssueCreate.constructor,"jira/projectissuenavigator/services/filters":y,"jira/flag":i,"jira/message":a}));this.search=this.sandbox.stub(new l());this.search.search.returns(new p.Deferred().promise());this.state=new o();this.issueSearch=new this.IssueSearchConstructor({state:this.state,search:this.search});this.issueSearch.show();this.el=this.issueSearch.el;this.stubErrorFlag()},stubErrorFlag:function(){this.sandbox.stub(v,"buildSimpleErrorContent");if(this.issueSearch.showErrorFlag.restore){this.issueSearch.showErrorFlag.restore()}return this.sandbox.stub(this.issueSearch,"showErrorFlag")},teardown:function(){JIRA.Projects.Subnavigator=w;this.sandbox.restore();p(document.body).removeClass("page-type-split page-issue-navigator")},assertState:function(z){x.each(z,function(B,A){if(A===null){ok(!this.state.has(A))}else{equal(this.state.get(A),B,"Internal state for "+A)}}.bind(this))},assertEventTriggered:function(B,C){var A=this.issueSearch.trigger;sinon.assert.calledOnce(A);var z=A.lastCall;equal(z.args[0],B,"The correct event was dispatched");deepEqual(z.args[1],C,"the correct payload was sent")},assertSearch:function(A,z){z=z||this.issueSearch;sinon.assert.calledOnce(z.search);sinon.assert.calledWith(z.search,A)},withSidebarIssueSearchThatCanCreateIssues:function(){var z=new this.IssueSearchConstructor({canCreateIssues:true,router:this.router,state:this.state,search:this.search});z.show();return z}});test("When searching data, it changes the state to represent the load params",function(){this.issueSearch.search({filter:"updatedrecently",issue:"TEMP-123",orderby:"key DESC"});this.assertState({filter:"updatedrecently",issue:"TEMP-123",orderby:"key DESC"})});test("When searching data for the second time, it uses the previous state if none is provided",function(){this.issueSearch.search({filter:"updatedrecently",issue:"TEMP-123",orderby:"key DESC"});this.issueSearch.search({issue:"TEMP-124"});this.assertState({filter:"updatedrecently",issue:"TEMP-124",orderby:"key DESC"})});test("When searching data for the second time, it can erase data from the state if null is provided",function(){this.issueSearch.search({filter:"updatedrecently",issue:"TEMP-123",orderby:"key DESC"});this.issueSearch.search({orderby:null});this.assertState({filter:"updatedrecently",issue:"TEMP-123",orderby:null})});test("When searching data, it does a search using a JQL based on the filter, project and orderby states",function(){this.search.search.returns(new p.Deferred().promise());this.state.set("project","DEMO");y.getJQL.withArgs("updatedrecently","DEMO","key DESC").returns('project = "DEMO" AND updated >= -1w ORDER BY key DESC');this.issueSearch.search({filter:"updatedrecently",orderby:"key DESC"});sinon.assert.calledOnce(this.search.search);sinon.assert.calledWith(this.search.search,'project = "DEMO" AND updated >= -1w ORDER BY key DESC')});test("When searching data, it can jump to a particular startIndex",function(){var z=new g([],{issues:[{id:1,key:"DEMO-1"},{id:2,key:"DEMO-2"},{id:3,key:"DEMO-3"},{id:4,key:"DEMO-4"}]});this.search.search.returns(new p.Deferred().resolve(z).promise());this.issueSearch.search({startIndex:"2"});sinon.assert.calledOnce(this.detailsLayout.load);sinon.assert.calledWith(this.detailsLayout.load,z,"DEMO-3")});test("When searching data, it ignores the startIndex if there is a selected issue",function(){var z=new g([],{issues:[{id:1,key:"DEMO-1"},{id:2,key:"DEMO-2"},{id:3,key:"DEMO-3"},{id:4,key:"DEMO-4"}]});this.search.search.returns(new p.Deferred().resolve(z).promise());this.issueSearch.search({startIndex:"1",issue:"DEMO-4"});sinon.assert.calledOnce(this.detailsLayout.load);sinon.assert.calledWith(this.detailsLayout.load,z,"DEMO-4")});test("When searching data, if the load fails then an error flag is shown and the loading view is hidden",function(){this.search.search.returns(new p.Deferred().reject());this.issueSearch.search();sinon.assert.calledOnce(this.issueSearch.showErrorFlag);sinon.assert.calledOnce(this.detailsLayout.hideLoading)});test("When searching data, if the load fails due to a 400. It should display the first error message in the response",function(){var z="jira.jql.validation.no.such.field";var A={responseText:'{"errorMessages":["'+z+'"]}',status:400};this.search.search.returns(new p.Deferred().reject(A));this.issueSearch.search();sinon.assert.calledOnce(this.issueSearch.showErrorFlag);sinon.assert.calledWith(this.issueSearch.showErrorFlag,z)});test("The error flag should not allow XSS",function(){var A="Error in the JQL Query: The quoted string '><b class='the-problem'>whoops, xss hole</b>' has not been completed. (line 1, character 54)";var z=AJS.escapeHtml(A);var B={responseText:'{"errorMessages":["'+A+'"]}',status:400};this.stub(i,"showErrorMsg");this.issueSearch.showErrorFlag.restore();i.showErrorMsg.withArgs(A)["throws"]("whoops, an XSS happened");i.showErrorMsg.withArgs(sinon.match.string,A)["throws"]("whoops, an XSS happened");this.search.search.returns(new p.Deferred().reject(B));this.issueSearch.search();sinon.assert.calledOnce(i.showErrorMsg);sinon.assert.calledWith(i.showErrorMsg,sinon.match.string,z)});test("When searching data, if the load fails due to a timeout. It should display a timeout message.",function(){var z={statusText:v.SmartAjaxResult.TIMEOUT,status:0};this.search.search.returns(new p.Deferred().reject(z));this.issueSearch.search();sinon.assert.calledOnce(this.issueSearch.showErrorFlag);sinon.assert.calledWith(v.buildSimpleErrorContent,z)});test("When the DetailsLayout triggers a 'select' event, the event is re-triggered as 'issue:select'",function(){this.detailsLayout.trigger("select",{key:"TEMP-456"});this.assertEventTriggered("issue:select",{issue:"TEMP-456"})});test("When the DetailsLayout triggers a 'select' event, the issue is updated in the state",function(){this.detailsLayout.trigger("select",{key:"TEMP-456"});this.assertState({issue:"TEMP-456"})});test("When the DetailsLayout triggers a 'empty' event, the event is re-triggered as 'issue:empty'",function(){this.detailsLayout.trigger("empty");this.assertEventTriggered("issue:empty")});test("When the DetailsLayout triggers an 'empty' event, the issue is removed from the state",function(){this.state.set("issue","TEMP-456");this.detailsLayout.trigger("empty");this.assertState({issue:null})});test("When the DetailsLayout triggers a 'list:sort' event, it loads new issues with the new orderby",function(){this.detailsLayout.trigger("list:sort","project = DEMO AND updated >= -1w ORDER BY updated DESC");this.assertSearch({orderby:"updated DESC"})});test("When the DetailsLayout triggers an 'error:loadpage' event, the sidebar issue nav shows an error flag",function(){this.detailsLayout.trigger("error:loadpage");sinon.assert.calledOnce(this.issueSearch.showErrorFlag)});test("When the Subnavigator triggers a 'itemSelected' event, it loads new issues with the new filter and the orderby is cleared",function(){this.subnavigator.trigger("itemSelected",{item:{id:"addedrecently",jql:"reporter = currentUser()"},preventDefault:this.spy()});this.assertSearch({filter:"addedrecently",issue:null,orderby:null})});test("When the detailslayout triggers a 'render' event, an equivalent JIRA event is triggered",function(){var z=this.spy(d,"trigger");this.detailsLayout.trigger("render");sinon.assert.calledOnce(z);sinon.assert.calledWith(z,s.LAYOUT_RENDERED)});test("When a filter is selected in the Subnavigator, it starts recording browser metrics",function(){var z=this.spy(h,"startIssueSearch");var A={item:{id:"addedrecently",jql:"reporter = currentUser()"},preventDefault:this.spy()};this.subnavigator.trigger("itemSelected",A);sinon.assert.calledOnce(z)});test("When a filter is selected in the Subnavigator, it triggers a 'filterSelected' event with the information of the filter",function(){var z=this.spy();this.issueSearch.on("filterSelected",z);var A={item:{id:"addedrecently",jql:"reporter = currentUser()"},preventDefault:this.spy()};this.subnavigator.trigger("itemSelected",A);sinon.assert.calledOnce(z);sinon.assert.calledWith(z,{filterId:"addedrecently",source:"subnavigator"})});test("When the list is sorted in the DetailsLayout, it starts recording browser metrics",function(){var A=this.spy(h,"startIssueSearch");var z="";this.detailsLayout.trigger("list:sort",z);sinon.assert.calledOnce(A)});test("When the list is refreshed in the DetailsLayout, it starts recording browser metrics",function(){var z=this.spy(h,"startIssueSearch");this.detailsLayout.trigger("list:refresh");sinon.assert.calledOnce(z)});test("When an item is selected in the DetailsLayout, it starts recording browser metrics",function(){var z=this.spy(h,"startIssueSearch");var A={};this.detailsLayout.trigger("list:select",A);sinon.assert.calledOnce(z)});test("When the list of issue is paginated in the DetailsLayout, it starts recording browser metrics",function(){var z=this.spy(h,"startIssueSearch");this.detailsLayout.trigger("list:pagination");sinon.assert.calledOnce(z)});test("When an issue is loaded from the cache in the DetailsLayout, it stops recording browser metrics",function(){var z=this.spy(h,"endIssueSearch");var A={};this.detailsLayout.trigger("editorLoadedFromCache",A);sinon.assert.calledOnce(z)});test("When an issue is loaded in the DetailsLayout, it stops recording browser metrics",function(){var z=this.spy(h,"endIssueSearch");var A={};this.detailsLayout.trigger("editorLoaded",A);sinon.assert.calledOnce(z)});test("When an issue is loaded in the DetailsLayout it should pass event.issueEditorOptions.issueRefreshedEvent===true as a issueRefreshedEvent parameter set to true",function(){var z={issueEditorOptions:{issueRefreshedEvent:true}};this.detailsLayout.trigger("editorLoaded",z);sinon.assert.calledOnce(this.issueSearch.trigger);sinon.assert.calledWith(this.issueSearch.trigger,"editorLoaded",{issueRefreshedEvent:true})});test("When an issue is loaded in the DetailsLayout it should pass event.issueEditorOptions.issueRefreshedEvent===false as a issueRefreshedEvent parameter set to false",function(){var z={issueEditorOptions:{issueRefreshedEvent:false}};this.detailsLayout.trigger("editorLoaded",z);sinon.assert.calledOnce(this.issueSearch.trigger);sinon.assert.calledWith(this.issueSearch.trigger,"editorLoaded",{issueRefreshedEvent:false})});test("When an issue is loaded in the DetailsLayout it should pass empty event.issueEditorOptions as a issueRefreshedEvent parameter set to false",function(){var z={};this.detailsLayout.trigger("editorLoaded",z);sinon.assert.calledOnce(this.issueSearch.trigger);sinon.assert.calledWith(this.issueSearch.trigger,"editorLoaded",{issueRefreshedEvent:false})});test("When the next issue is selected, it start recording browser metrics",function(){var z=this.spy(h,"startIssueSearch");this.detailsLayout.trigger("pager:next",{current:1,total:2});sinon.assert.calledOnce(z)});test("When the previous issue is selected, it start recording browser metrics",function(){var z=this.spy(h,"startIssueSearch");this.detailsLayout.trigger("pager:previous",{current:1,total:2});sinon.assert.calledOnce(z)});test("When the next issue is selected, it should trigger an event",function(){var z=this.spy();this.issueSearch.on("pager:next",z);this.detailsLayout.trigger("pager:next",{current:1,total:2});sinon.assert.calledOnce(z)});test("When the previous issue is selected, it should trigger an event",function(){var z=this.spy();this.issueSearch.on("pager:previous",z);this.detailsLayout.trigger("pager:previous",{current:1,total:2});sinon.assert.calledOnce(z)});test("When constructed with an user that can create issues, it ask the DetailsLayout to display the IIC",function(){this.withSidebarIssueSearchThatCanCreateIssues();equal(this.detailsLayout.constructor.lastCall.args[0].displayInlineIssueCreate,true)});test("When constructed with an user that can create issues, it ask the DetailsLayout to display the IIC",function(){this.withSidebarIssueSearchThatCanCreateIssues();equal(this.detailsLayout.constructor.lastCall.args[0].displayInlineIssueCreate,true)});test("When an issue is created in the DetailsLayout and the current filter supports inline issue creation, we reload the current filter and select the created issue",function(){this.stub(y,"filterSupportsInlineIssueCreate").withArgs("aFilterId").returns(true);var z=this.withSidebarIssueSearchThatCanCreateIssues();this.state.set("project","DEMO");z.search({filter:"aFilterId",issue:"DEMO-1"});z.search.reset();this.detailsLayout.trigger("issueCreated",{issue:{issueKey:"DEMO-2"},fields:{summary:"This is a test"}});this.assertSearch({issue:"DEMO-2"},z);this.assertState({filter:"aFilterId",issue:"DEMO-2",project:"DEMO"},z)});test("When an issue is created in the DetailsLayout and the current filter does not support inline issue creation, we show a flag",function(){this.stub(y,"filterSupportsInlineIssueCreate").withArgs("aFilterId").returns(false);this.stub(a,"showSuccessMsg");this.state.set("project","DEMO");var z=this.withSidebarIssueSearchThatCanCreateIssues();z.search({filter:"aFilterId",issue:"DEMO-1"});z.search.reset();this.detailsLayout.trigger("issueCreated",{issue:{issueKey:"DEMO-2"},fields:{summary:"This is a test"}});sinon.assert.notCalled(z.search);this.assertState({filter:"aFilterId",issue:"DEMO-1",project:"DEMO"},z);sinon.assert.calledOnce(a.showSuccessMsg)});test("When the DetailsLayout triggers a 'empty' event, if the IIC mode is enabled whe display the IIC widget",function(){var B=p("<div></div>");var z="project=DEMO";var A=this.withSidebarIssueSearchThatCanCreateIssues();this.emptyView.inlineIssueCreateContainer=new k.Region({el:B});A.emptyView=this.emptyView;this.state.set("searchResults",new g([],{jql:z}));this.detailsLayout.trigger("empty");sinon.assert.calledOnce(this.inlineIssueCreate.show);sinon.assert.calledWith(this.inlineIssueCreate.show,this.emptyView.inlineIssueCreateContainer.$el)});test("When the DetailsLayout triggers a 'empty' event, if the IIC is activated with the results JQL",function(){var B=p("<div></div>");var z="project=DEMO";var A=this.withSidebarIssueSearchThatCanCreateIssues();this.emptyView.inlineIssueCreateContainer=new k.Region({el:B});A.emptyView=this.emptyView;this.state.set("searchResults",new g([],{jql:z}));this.detailsLayout.trigger("empty");sinon.assert.calledOnce(this.inlineIssueCreate.activateWithJQL);sinon.assert.calledWith(this.inlineIssueCreate.activateWithJQL,z)});test("When searching data and we correct the filter, it triggers a 'filterSelected' event with the information of the new filter",function(){var A=this.spy();this.issueSearch.on("filterSelected",A);var z=new g([],{issues:[{id:1,key:"DEMO-1"},{id:2,key:"DEMO-2"}],jql:'project = "DEMO" AND updated >= -1w ORDER BY key DESC'});this.search.search.returns(new p.Deferred().resolve(z).promise());this.issueSearch.search({filter:"updatedrecently",issue:"DEMO-3"});sinon.assert.calledOnce(A);sinon.assert.calledWith(A,{filterId:"allissues",source:"issueFilterMismatch"})});test("When the user select the Manage Filters in the subnavigator, it doesn't change the title'",function(){var z=this.el.find("#issues-subnavigation-title");z.text("Open issues");this.subnavigator.trigger("itemSelected",{item:{id:"manage",jql:true},preventDefault:function(){}});equal(z.text(),"Open issues")});test("When the user selects any other filter in the subnavigator, it changes the title'",function(){var z=this.el.find("#issues-subnavigation-title");z.text("Open issues");this.issueSearch.subnavigation.trigger("itemSelected",{item:{id:"allopenissues",jql:true},preventDefault:function(){}});equal(z.text(),"")});test("When the user select the Manage Filters in the subnavigator, it triggers the event 'manageFilters'",function(){var z=this.spy();this.issueSearch.on("manageFilters",z);this.subnavigator.trigger("itemSelected",{item:{id:"manage"}});sinon.assert.calledOnce(z)});test("When the DialogsOverrider is constructed, it is provided with the correct callbacks",function(){sinon.assert.calledOnce(this.dialogsOverrider.constructor);var z=this.dialogsOverrider.constructor.args[0][0];this.detailsLayout.getActiveIssueId.returns(1);equal(z.getIssueId(),1);var A={};A.$activeTrigger={};A.$activeTrigger.data=sinon.stub();A.$activeTrigger.data.withArgs("issueid").returns(2);equal(z.getIssueId(A),2);this.detailsLayout.getActiveIssueKey.returns("KEY-1");equal(z.getIssueKey(),"KEY-1");A.$activeTrigger.data.withArgs("issuekey").returns("KEY-2");equal(z.getIssueKey(A),"KEY-2")});test("When an issue is removed, it is also removed from the DetailsLayout",function(){this.detailsLayout.removeIssue.returns(new p.Deferred().resolve().promise());this.dialogsOverrider.trigger("issueDelete",{issueId:1});sinon.assert.calledOnce(this.issueSearch.removeIssue);sinon.assert.calledWith(this.issueSearch.removeIssue,1);sinon.assert.calledOnce(this.detailsLayout.removeIssue);sinon.assert.calledWith(this.detailsLayout.removeIssue,1)});test("When the DetailsLayout triggers a 'editor:saveSuccess' event, the event is re-triggered as 'editor:saveSuccess'",function(){this.detailsLayout.trigger("editor:saveSuccess",{event:"123456",savedFieldIds:["fieldId-1"],savedFieldTypes:["fieldType-1"],duration:123});this.assertEventTriggered("editor:saveSuccess",{issueId:"123456",savedFieldIds:["fieldId-1"],savedFieldTypes:["fieldType-1"],duration:123})});test("When the DetailsLayout triggers a 'editor:editField' event, the event is re-triggered as 'editor:editField'",function(){var z={issueId:"123456",issueKey:"TEST-1",fieldId:"field-123",fieldType:"field-type"};this.detailsLayout.trigger("editor:editField",z);this.assertEventTriggered("editor:editField",z)});test("When the DetailsLayout triggers a 'editor:editFieldCancel' event, the event is re-triggered as 'editor:editFieldCancel'",function(){var z={issueId:"123456",issueKey:"TEST-1",fieldId:"field-123",fieldType:"field-type"};this.detailsLayout.trigger("editor:editFieldCancel",z);this.assertEventTriggered("editor:editFieldCancel",z)});test("When focusing the issue list, it delegates the call to the internal DetailsLayout component",function(){this.issueSearch.focusIssueList();sinon.assert.calledOnce(this.detailsLayout.focusList)});test("When focusing the issue editor, it delegates the call to the internal DetailsLayout component",function(){this.issueSearch.focusIssueEditor();sinon.assert.calledOnce(this.detailsLayout.focusEditor)});test("When the DetailsLayout triggers an 'individualPanelRendered' event, it is re-triggered with the same payload",function(){var z={data:123};this.detailsLayout.trigger("individualPanelRendered",z);this.assertEventTriggered("individualPanelRendered",z)});test("When getting the project id, it delegates the call to the internal DetailsLayout component",function(){this.detailsLayout.getActiveProjectId.returns(123);var z=this.issueSearch.getProjectId();sinon.assert.calledOnce(this.detailsLayout.getActiveProjectId);equal(z,123)});test("When getting the project key, it delegates the call to the internal DetailsLayout component",function(){this.detailsLayout.getActiveProjectKey.returns("TEST");var z=this.issueSearch.getProjectKey();sinon.assert.calledOnce(this.detailsLayout.getActiveProjectKey);equal(z,"TEST")});test("When getting the project type, it delegates the call to the internal DetailsLayout component",function(){this.detailsLayout.getActiveProjectType.returns("software");var z=this.issueSearch.getProjectType();sinon.assert.calledOnce(this.detailsLayout.getActiveProjectType);equal(z,"software")})})});