define('jira/projectissuenavigator/init', ['require'], function (require) {
    "use strict";

    var ProjectIssueNavigator = require('jira/projectissuenavigator');
    var Meta = require('jira/util/data/meta');
    var WrmData = require('wrm/data');
    var jQuery = require('jquery');

    function init(element) {
        var projectIssueNavigator = new ProjectIssueNavigator({
            el: jQuery(element),
            canCreateIssues: WrmData.claim("com.atlassian.jira.jira-projects-issue-navigator:can-create-issues"),
            emptyViewContent: WrmData.claim("com.atlassian.jira.jira-projects-issue-navigator:empty-state-panel-html")
        });
        projectIssueNavigator.start();

        JIRA.API.getSidebar().done(function (Sidebar) {
            var AUISidebar = Sidebar.getAUISidebar();

            AUISidebar.on('collapse-end', function () {
                projectIssueNavigator.adjustSize();
            });

            AUISidebar.on('expand-end', function () {
                projectIssueNavigator.adjustSize();
            });
        });
    }

    jQuery(function () {
        // Horrible hack. This should go away during JDEV-31262
        jQuery("fieldset.parameters input[title=loggedInUser]").val(Meta.get("remote-user"));
    });

    return init;
});

require([
    'jira/components/issueviewer/services/darkfeatures',
    'jira/projectissuenavigator/init',
    'jira/skate',
    'jquery'
], function (
    DarkFeatures,
    init,
    skate,
    jQuery
) {
    "use strict";

    if (!DarkFeatures.REDIRECT_FROM_GLOBAL_TO_PROJECT.enabled()) {
        jQuery(function () {
            init(jQuery('.issue-navigator').get(0));
        });
    } else {
        skate('issue-navigator-init', {
            type: skate.type.CLASSNAME,
            attached: function () {
                init(jQuery('.issue-navigator').get(0));
            }
        });
    }
});
