define("jira/projectissuenavigator/entities/navigatorstate", ['require'], function (require) {
    "use strict";

    var _ = require('jira/projectissuenavigator/libs/underscore');
    var Backbone = require('jira/projectissuenavigator/libs/backbone');

    return Backbone.Model.extend({
        defaults: {
            project: undefined,
            issue: undefined,
            filter: undefined,
            orderby: undefined,
            searchResults: undefined,
            startIndex: undefined
        },

        /**
         * Update the properties of the model in batch mode
         *
         * If the property has a non null, this method will set the model attribute to the provided value. If the
         * property has a null value, this method will unset that attribute.
         *
         * Example
         *
         *   model.update({
         *       'issue': 'KEY-123',
         *       'orderby': null
         *   });
         *
         * is equivalent to
         *
         *   model.set('issue', 'KEY-123');
         *   model.unset('orderby');
         *
         * @param {Object.<string, *>} state List of properties to set/unset
         */
        update: function (state) {
            _.each(state, function (value, key) {
                if (value === null) {
                    this.unset(key);
                } else if (value !== undefined) {
                    this.set(key, value);
                }
            }.bind(this));
        }
    });
});
