AJS.toInit(function ($) {

    $(document).on("click", "#dialog-save-button", function (e) {

        e.preventDefault();
        clearErrorPanel();
        var selected = $("#allowAutoConvertCheckbox").attr('checked') === "checked";
        var url = AJS.contextPath() + '/rest/hipchat/integrations/1.0/configuration';

        var projectVal = $("#project-key").val();
        var data = {"allowAutoConvert": selected};
        if (projectVal != undefined) {
            data["projectKey"] = projectVal;
        }

        var guestRoomAccess = $("#allowAutoConvertInGuestRooms");

        if(guestRoomAccess.val() != undefined){
            var issuePreviewInGuestRooms = guestRoomAccess.attr('checked') === "checked";
            data['guestRoomEnabled'] = issuePreviewInGuestRooms;
        }

        $.ajax({
            url: url,
            data: JSON.stringify(data),
            contentType: 'application/json',
            cache: false,
            type: "POST"
        }).error(function(error){
            showError(error);
        }).done(function (data) {
            $("#dialog-close-button").click();
        });
    });

    /**
     * We clear the error panel before every transaction
     */
    function clearErrorPanel() {
        var errorPanel = $("#error-panel");
        errorPanel.hide(); // Just in case is visible...
        errorPanel.empty();
    }

    /**
     * We populate the error in the db
     */
    function showError(error) {
        var errorPanel = $("#error-panel");
        errorPanel.append(" Could not complete the action : Status [" + error.status + "] Reason [" + error.statusText + "]");
        errorPanel.show();
    }
});

(function(){

    JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, $ctx) {
        initLargeDialogs($ctx);
    });

    function initLargeDialogs(context) {
        context.find("a.trigger-dialog-large").each(function () {
            new JIRA.FormDialog({
                trigger: this,
                id: this.id + "-dialog",
                ajaxOptions: {
                    url: this.href,
                    data: {
                        decorator: "dialog",
                        inline: "true"
                    }
                },
                width: 760
            });
        });
    }

})(jQuery);

