(function (
    $,
    Mapping,
    Mappings,
    MappingView,
    RoomMappingPageView
) {
    function init() {
        var mappings = new Mappings();

        var $roomConfigurations = $("#hipchat-room-configuration");

        _.each($roomConfigurations.find(".hipchat-room-config"), function(i) {
            var $roomConfig = $(i);
            var mapping = new Mapping({
                roomId: $roomConfig.data("room-id"),
                roomName: $roomConfig.data("room-name"),
                configurationGroupId: $roomConfig.data("configuration-group-id"),
                projectKey: $roomConfig.data("project-key"),
                projectName: $roomConfig.data("project-name"),
                projectId: $roomConfig.data("project-id")
            });
            var mappingView = new MappingView({
                model: mapping,
                el: $roomConfig
            });

            mappings.add(mapping);
        }, this);

        new RoomMappingPageView({
            el: $roomConfigurations,
            collection: mappings
        });
    }

    $(function() {
        init();
    });
})(
    require("jquery"),
    require("hipchat/feature/roommapping/mapping"),
    require("hipchat/feature/roommapping/mapping-collection"),
    require("hipchat/feature/roommapping/mapping-view"),
    require("hipchat/feature/roommapping/roommapping-page")
);