define("hipchat/feature/issuepanel/issuepanel-view",
[
    "jquery",
    "backbone",
    "hipchat/base",
    "hipchat/feature/issuepanel/dedicatedroom",
    "hipchat/feature/issuepanel/dedicatedroom-view",
    "hipchat/feature/issuepanel/issuemention",
    "hipchat/feature/issuepanel/issuemention-view"
], function (
    $,
    Backbone,
    HipChat,
    DedicatedRoom,
    DedicatedRoomView,
    IssueMention,
    IssueMentionView
) {
        var hipchatLinkClickedKey = "hipchat.inapp.links.first.clicked";
        var hipchatNativeLinksFeatureDiscovery = "hipchat.inapp.links";
        var cookieExpiresInDays = 1;

        var IssuePanelView = HipChat.View.extend({
        events: {
            "click #hipchat-issue-panel-configure-button": "configure",
            "click #hipchat-issue-panel-hide": "dismissPanel"
        },

        initialize: function(options) {
            this.initDedicatedView();
            this.initIssueMentionView();
            this.initPanelSettings();
        },

        initDedicatedView: function() {
            var issuePanelDetails = this.getIssuePanelDetails();
            var dedicatedRoomOptions = {};
            if (issuePanelDetails.dedicatedRoomId) {
                dedicatedRoomOptions = {
                    issue_key: issuePanelDetails.issueKey,
                    room_id: issuePanelDetails.dedicatedRoomId
                };
            }
            var model = new DedicatedRoom(dedicatedRoomOptions);

            var options = _.extend(issuePanelDetails, {
                el: this.$("#hipchat-dedicated-room-section"),
                model: model
            });
            this.dedicatedRoomView = new DedicatedRoomView(options);
        },

        initIssueMentionView: function() {
            var issuePanelDetails = this.getIssuePanelDetails();
            var options = _.extend({
                el: this.$("#hipchat-mentioned-rooms-section"),
                model: new IssueMention({ issue_key: issuePanelDetails.issueKey })
            }, issuePanelDetails);
            this.issueMentionView = new IssueMentionView(options);

            this.issueMentionView.on("ready", this.ready, this);
        },

        close: function() {
            this.dedicatedRoomView.close();
            this.issueMentionView.close();
        },

        ready: function() {
            this.trigger("ready");
        },

        getIssuePanelDetails: function() {
            var $panelContainer = this.$el;
            var loggedIn = $panelContainer.data("logged-in");
            var canCreateRoom = $panelContainer.data("can-create-room");
            var canAssignRoom = $panelContainer.data("can-assign-room");
            var isAdmin = AJS.Meta.get("is-admin");
            var hipChatUserName = $panelContainer.data("hipchat-username");
            var dedicatedRoomId = $panelContainer.data("dedicated-room-id");
            var hipChatConfigured = $panelContainer.data("hipchat-configured");
            var issueKey = AJS.Meta.get("issue-key");
            return {
                loggedIn: loggedIn,
                canCreateRoom: canCreateRoom,
                canAssignRoom: canAssignRoom,
                isAdmin: isAdmin,
                hipChatUserName: hipChatUserName,
                dedicatedRoomId: dedicatedRoomId,
                hipChatConfigured: hipChatConfigured,
                issueKey: issueKey
            };
        },

        dismissPanel: function(e) {
            e.preventDefault();

            var $panelContainer = this.$el;
            var projectKey = $panelContainer.data("project-key");
            var self = this;
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + '/rest/hipchat/integrations/1.0/issuepanel/hide?projectKey=' + projectKey,
                dataType: 'json',
                cache: false
            }).done(function() {
                self.close();
                $("#hipchat-viewissue-panel").remove();
            }).fail(function() {

            });
        },

        configure: function(e) {
            var target = $(e.currentTarget);
            window.location = target.data("configure-url");
        },

        initPanelSettings: function() {

            // We only show the panel if the user is a MAC user
            if(navigator.platform.toUpperCase().indexOf('MAC') >= 0 && AJS.Meta.get("issue-key") !== undefined){

                var $panel = $("#hipchat-panel-settings");

                if($panel === undefined){
                    return; //Maybe the panel is not there.
                }

                $panel.removeClass("hidden");

                $panel.click(function (event) {
                    event.preventDefault();
                    showDialog($(event.target), false);
                });

                // If someone enabled/disabled the advanced settings
                $(document).on("click", "#hipchat-inapp-links", function (event) {
                    var enabled = $(event.target).is(":checked");
                    AJS.Cookie.save("HIPCHAT_NATIVE_LINK_ENABLED", enabled);

                    var analyticEvent  = "jira.hipchat.integration.issuepanel.native.link." + (enabled ? "enabled" : "disabled");
                    AJS.trigger('analyticsEvent', {name: analyticEvent});
                });

                $(document).on("click", ".hipchat-room-link-url", function (event) {
                    setUserClickedALink();
                });

                $(document).on("click", ".hipchat-user-link-url", function (event) {
                    setUserClickedALink();
                });

                validateFirstTime($panel);
            }

            var confirmDialog;

            function showDialog($target, firstTime) {
                if (!confirmDialog) {
                    // we need to remove any existing dialog, which may have been left behind from previous issues
                    // when a new issue is Ajax loaded
                    AJS.$("#inline-dialog-hipchat-link-dialog").remove();
                    
                    confirmDialog = AJS.InlineDialog($target, "hipchat-link-dialog",
                            function (content, trigger, showPopup) {
                                var params = {isAppLinkEnable: AJS.Cookie.read("HIPCHAT_NATIVE_LINK_ENABLED") === "true"};
                                content.html(JIRA.Templates.HipChat.Config.LinkSettings.enableInAppLinksForHipChat(params));
                                showPopup();
                                return false;
                            }, {
                                hideDelay: null
                            });
                }
                confirmDialog.show();

                var url = AJS.contextPath() + '/rest/api/2/mypreferences?key=';

                // Now we set the variable so the feature discovery ends...
                $.ajax({
                    url: url + hipchatNativeLinksFeatureDiscovery,
                    contentType: 'application/json',
                    cache: false,
                    type: "PUT",
                    data: "true"
                });

                if(firstTime){
                    AJS.trigger('analyticsEvent', {name: 'jira.hipchat.integration.issuepanel.native.link.discovery'});
                }

                saveCookie(hipchatNativeLinksFeatureDiscovery, true);
            }


            /**
             * We clicked a link so we are going to store this in a cookie and a preference, and in the next
             * refresh if the user did not get the feature discovery then we show it.
             */
            function setUserClickedALink() {

                var linkClicked = getCookieForUser(hipchatLinkClickedKey);

                if(linkClicked === "undefined" || linkClicked === "false"){
                    saveCookie(hipchatLinkClickedKey , true);
                    var url = AJS.contextPath() + '/rest/api/2/mypreferences?key=' + hipchatLinkClickedKey;
                    $.ajax({ url: url, contentType: 'application/json', cache: false, type: "PUT", data: "true"});
                }
            }

            /**
             * We save the cookie with the user id, to guarantee that
             * we can login/logout without having problems
             * @param cookie the cookie
             * @param value the value to store
             */
            function saveCookie(cookie, value){
                var username = AJS.Meta.get("remote-user")
                var cookieName = cookie + "." + username;
                AJS.Cookie.save(cookieName, value, cookieExpiresInDays);
            }

            function getCookieForUser(cookie){
                var username = AJS.Meta.get("remote-user")
                var cookieName = cookie + "." + username;
                return AJS.Cookie.read(cookieName);
            }

            /**
             * First we check the cookies, if the cookies say true/true then we already checked and we forget about this
             * If no cookies are set then we ask first if something was clicked, if it was then we check if it was shown or not
             * Depending on that we show the popup.
             * This is the way to verify that the user is using the functionality and showing the things they need.
             * @param $panel the panel
             */
            function validateFirstTime($panel) {

                var url = AJS.contextPath() + '/rest/api/2/mypreferences?key=';

                // If both cookies are true it means that the user clicked a link, and we already showed
                // the popup. This is much better than asking every time the issue loads for this 2 user preferences
                var linkClicked = getCookieForUser(hipchatLinkClickedKey);

                if (linkClicked === "true") {

                    if (getCookieForUser(hipchatNativeLinksFeatureDiscovery) === "true") {
                        return;
                    }

                    $.ajax({
                        url: url + hipchatNativeLinksFeatureDiscovery,
                        dataType: 'json',
                        cache: false
                    }).fail(function (data) {

                        if (data.status == 404) {

                            showDialog($panel, true);

                        }
                    }).success(function (onsuccess) {
                        // This happened in other browser or other session
                        saveCookie(hipchatNativeLinksFeatureDiscovery, true)
                    });

                } else if (linkClicked === undefined) { // Only if we don't know anything about the link we evaluate

                    $.ajax({
                        url: url + hipchatLinkClickedKey,
                        dataType: 'json',
                        cache: false
                    }).success(function (data) {

                        saveCookie(hipchatLinkClickedKey, true);
                        validateFirstTime($panel); //We do the logic again

                    }).fail(function (failure) {
                        saveCookie(hipchatLinkClickedKey, false);
                    });
                }
            }
        }
    });

    return IssuePanelView;
});