require([
    "ajs", // only to make karma happy
    "jquery",
    "jira/util/data/meta",
    "jira/util/events",
    "jira/util/events/types",
    "wrm/context-path",
    "hipchat/feature/issuepanel/issuepanel-view"
], function (
    AJS,
    $,
    Meta,
    Events,
    Types,
    wrmContextPath,
    IssuePanelView
) {

    /**
     * We track any hash actions to be able to know if we are being redirected
     * from other place
     */
    function evaluateImmediateActions() {
        var hash = window.location.hash;

        if (hash === "#choose-room") {
            $("#hipchat-select-dedicated-room").click();
            cleanHash();
        } else if (hash === "#create-dedicated-room") {
            $(".hipchat-create-dedicated-room").click();
            cleanHash();
        } else if (hash === "#open-issue-mentions") {
            $("#hipchat-issue-mentions-list").click();
            cleanHash();
        } else if(hash === "#delete-dedicated-room") {
            $(".trash-dedicated-room").click();
        }
    }

    function cleanHash() {
        window.location.hash = "";
    }

    function createIssuePanelView() {
        return new IssuePanelView({
            el: $("#hipchat-issue-panel-rooms-container")
        });
    }

    var issuePanelView = null;
    function init() {
        getTemplate();

        Events.bind(Types.ISSUE_REFRESHED, function () {
            // HC-11688: Actions on the issue (transition, edit...) will refresh the content of the sidebar.

            if (issuePanelView !== null){
                issuePanelView.close();
            }
            getTemplate();
        });
    }

    function getTemplate() {
        var issueKey = Meta.get("issue-key");
        if (issueKey) {
            var $issuePanel = $("#hipchat-issue-panel");
            var $spinner = $("#hipchat-issue-panel-spinner");
            var $errors = $("#hipchat-issue-panel-errors");
            $spinner.spin();
            return $.ajax({
                url: wrmContextPath() + "/rest/hipchat/integrations/1.0/issuepanel/data/" + issueKey,
                cache: false,
                dataType: 'json',
                type: "GET"
            }).done(function (data) {
                var template = JIRA.Templates.HipChat.Project.IssuePanel.hipChatPanel(data);
                $issuePanel.html(template);

                issuePanelView = createIssuePanelView();
                issuePanelView.on("ready", evaluateImmediateActions);
            }).fail(function (jqXHR, textStatus) {
                $errors.append(AJS.I18n.getText("jira.plugins.hipchat.viewissue.panel.error.getting.data"));
            }).always(function() {
                $spinner.spinStop();
            });
        }
    }

    $(function () {
        init();
    });
});
