define("hipchat/feature/issuepanel/issuemention-view",
[
    "jquery",
    "backbone",
    "hipchat/base"
], function (
    $,
    Backbone,
    HipChat
) {
    var IssueMentionView = HipChat.View.extend({

        events: {
            "click a.trigger-dialog-large": "openMentionDialog"
        },

        initialize: function(options) {
            this.loggedIn = options.loggedIn;
            this.canCreateRoom = options.canCreateRoom;
            this.isAdmin = options.isAdmin;
            this.issueKey = options.issueKey;
            this.hipChatUserName = options.hipChatUserName;
            this.hipChatConfigured = options.hipChatConfigured;

            this.model.on("sync", this.updateMentionCount, this);
            this.model.on("sync", this.ready, this);
            this.model.on("error", this.displayError, this);

            if (this.hipChatConfigured) {
                this.model.fetch();
            }
        },

        close: function() {
            this.unbind();
        },

        openMentionDialog: function(e) {
            e.preventDefault();

            var target = e.currentTarget;
            if (this.dialog === undefined) {
                this.dialog = new JIRA.FormDialog({
                    id: target.id + "-dialog",
                    ajaxOptions: {
                        url: target.href,
                        data: {
                            decorator: "dialog",
                            inline: "false"
                        }
                    },
                    width: 900
                });
            }

            this.dialog.show();
        },

        updateMentionCount: function() {
            var html = JIRA.Templates.HipChat.Project.IssuePanel.mentionedRoomsDescription({
                mentionedRooms: this.model.get("issueMentionRooms"),
                issueKey: this.issueKey,
                userLoggedIntoHipChat: this.loggedIn
            });

            this.$(".hipchat-mentioned-rooms-content").html(html);

            JIRA.trace("hipchat.mentioned.rooms.fetched");
        },

        ready: function() {
            this.trigger("ready");
        },

        displayError: function(model, resp, options) {
            var errorsContainer = this.$(".hipchat-mentioned-rooms-content");
            errorsContainer.empty();
            errorsContainer.append("<span class='errors'>" + AJS.I18n.getText("jira.plugins.hipchat.viewissue.panel.mentions.rooms.error") + "</span>");
        }
    });

    return IssueMentionView;
});