define("hipchat/feature/connect/glance-config",
[
    "jquery",
    "backbone"
], function (
        $,
        Backbone
) {
    var GlanceConfigModel = Backbone.Model.extend({
        idAttribute: "roomId",

        defaults: {
            roomId: '',
            state: '',
            jql: '',
            name: '',
            jiraUser: '',
            loginLink: '',
            jwtToken: '',
            editing: false
        },

        optOut: function(options) {
            var self = this;
            var optOutUrl = self.getCustomUrl('optout');
            $.post(optOutUrl, {}, function (data) {
                options.success(data);
            }, 'json').error(function (error) {
                        options.error(error);
                    }
            );
        },
        
        getCustomUrl: function (method) {
            var baseUrl = AJS.contextPath() + '/rest/hipchat/integrations/1.0/glance-configuration';
            switch (method) {
                case 'optout':
                    return baseUrl + '/' + this.get('roomId') + '/optout?signed_request=' + this.get('jwtToken');
                case 'read':
                case 'update':
                case 'delete':
                    return baseUrl + '/' + this.get('roomId') + '?signed_request=' + this.get('jwtToken');
                case 'create':
                default:
                    return baseUrl + '?signed_request=' + this.get('jwtToken');
            }
        },

        sync: function (method, model, options) {
            options || (options = {});
            options.url = this.getCustomUrl(method.toLowerCase());

            return Backbone.sync.apply(this, arguments);
        }
    });

    return GlanceConfigModel;
});