define("hipchat/feature/connect/glance-config-view",
[
    "jquery",
    "backbone",
    "hipchat/base",
    "hipchat/feature/connect/glance-config",
    "hipchat/feature/roommapping/querymodule"
], function (
        $,
        Backbone,
        HipChat,
        GlanceConfigModel,
        queryModule
) {
    var GlanceConfigView = Backbone.View.extend({
        events: {
            'click .save-glance-config': 'processSave',
            'click .cancel-edit-glance-config': 'processCancelEdit',
            'click .edit-glance-config': 'edit',
            'change .glance-config-checkbox': 'processCheckbox'
        },

        initialize: function () {
            this.model.on('change:editing', this.onEditChanged, this);
            this.model.on('change:checked', this.onCheckBoxChanged, this);
            this.setUpQueryModule();
        },

        render: function () {
            var html = JIRA.Templates.HipChat.Glance.configureInner({
                state: this.model.get('state'),
                roomId: this.model.get('roomId'),
                jql: this.model.get('jql'),
                name: this.model.get('name'),
                jiraUser: this.model.get('jiraUser'),
                loginLink: this.model.get('loginLink'),
                jwtToken: this.model.get('jwtToken'),
                editing: this.model.get('editing')
            });

            this.$el.empty();
            this.$el.append(html);

            queryModule.setJql(this.model.get('jql'));
            queryModule.switchView($('#jql-editor'));

            return this;
        },

        clear: function () {
            this.model.destroy();
        },

        setUpQueryModule: function () {
            queryModule.init({
                jql: '',
                primaryClauses: [
                    {
                        id: 'project',
                        name: 'Project'
                    },
                    {
                        id: 'issuetype',
                        name: 'Issue'
                    }, {
                        id: 'priority',
                        name: 'Priority'
                    }],
                style: 'hipchat',
                layoutSwitcher: false
            });
            var self = this;
            queryModule.setJql(this.model.get('jql'));
            queryModule.onJqlChanged(self.updateJql, self);
            queryModule.setIsJQLTooComplexFn(function (jql) { return false; });
            queryModule.switchView($('#jql-editor'));
        },

        updateJql: function (jql) {
            this.model.set('jql', jql);
        },

        processSave: function (event) {
            event.preventDefault();
            var self = this;
            self.$el.find(".save-glance-config").prop('disabled', true);
            self.$el.find(".glance-config-form-spinner").spin();
            var data = {
                jql: self.model.get('jql'),
                name: AJS.$('#glance-name-input').val(),
                state: 'CONFIGURED'
            };
            self.model.save(data, {success: function () {
                self.render();
                self.closeEdit();
                self.$el.find(".glance-config-form-spinner").spinStop();
                self.$el.find(".save-glance-config").prop('disabled', false);
                JIRA.trace("ajax.request.completed.GlanceConfigSave");
            }, error: function() {
                AJS.messages.error({
                    title: AJS.I18n.getText('jira.plugins.hipchat.glanceconfig.save.error'),
                    fadeout: true
                });
                self.$el.find(".glance-config-form-spinner").spinStop();
                self.$el.find(".save-glance-config").prop('disabled', false);
                JIRA.trace("ajax.request.completed.GlanceConfigSave");
            }});
        },

        processCancelEdit: function (event) {
            event.preventDefault();
            var self = this;
            self.$el.find(".cancel-edit-glance-config").prop('disabled', true);
            self.$el.find(".glance-config-form-spinner").spin();
            self.model.fetch({
                success: function() {
                    self.closeEdit();
                    self.model.set('checked', self.model.get('state') == 'CONFIGURED');
                    self.$el.find(".glance-config-form-spinner").spinStop();
                    self.$el.find(".cancel-edit-glance-config").prop('disabled', false);
                    self.render();
                    JIRA.trace("ajax.request.completed.GlanceConfigCancelEdit");
                }, error: function() {
                    AJS.messages.error({
                        title: AJS.I18n.getText('jira.plugins.hipchat.glanceconfig.clear.error'),
                        fadeout: true
                    });
                    self.$el.find(".glance-config-form-spinner").spinStop();
                    self.$el.find(".cancel-edit-glance-config").prop('disabled', false);
                    JIRA.trace("ajax.request.completed.GlanceConfigCancelEdit");
                }
            });
        },

        processOptOut: function () {
            var self = this;
            self.$el.find(".glance-config-checkbox").prop('disabled', true);
            self.$el.find(".glance-config-checkbox-spinner").spin();
            self.model.optOut({success: function (data) {
                self.model.set(data);
                self.render();
                self.$el.find(".glance-config-checkbox-spinner").spinStop();
                self.$el.find(".glance-config-checkbox").prop('disabled', false);
                JIRA.trace("ajax.request.completed.GlanceConfigOptOut");
            }, error: function(error) {
                AJS.messages.error({
                    title: AJS.I18n.getText('jira.plugins.hipchat.glanceconfig.delete.error'),
                    fadeout: true
                });
                self.$el.find(".glance-config-checkbox-spinner").spinStop();
                self.$el.find(".glance-config-checkbox").prop('disabled', false);
                self.model.set('checked', true);
                self.$el.find(".glance-config-checkbox").prop('checked', true);
                self.$el.find("#hipchat-glance-config-inner").addClass("checked");
                JIRA.trace("ajax.request.completed.GlanceConfigOptOut");
            }});
        },

        edit: function () {
            this.model.set('editing', true);
            queryModule.setJql(this.model.get('jql'));
            queryModule.switchView($('#jql-editor'));
        },

        closeEdit: function () {
            if (this.model.get('state') == 'CONFIGURED') {
                this.model.set('editing', false);
            }
        },

        onEditChanged: function () {
            if (this.model.get("editing")) {
                this.$el.find("#hipchat-glance-config-inner").addClass("expanded");
                JIRA.trace("ajax.request.completed.GlanceConfigExpand");
            } else {
                this.$el.find("#hipchat-glance-config-inner").removeClass("expanded");
                JIRA.trace("ajax.request.completed.GlanceConfigCollapse");
            }
        },

        processCheckbox: function () {
            var checked = this.$el.find('.glance-config-checkbox').is(':checked');
            if (checked) {
                this.checkTheBox();
            } else {
                this.uncheckTheBox();
            }
        },

        checkTheBox: function () {
            this.model.set('checked', true);
        },

        uncheckTheBox: function () {
            this.model.set('checked', false);
        },

        onCheckBoxChanged: function () {
            if (this.model.get("checked")) {
                this.$el.find("#hipchat-glance-config-inner").addClass("checked");
                JIRA.trace("ajax.request.completed.GlanceConfigOptingIn");
            } else {
                if (this.model.get('state') == 'CONFIGURED' || this.model.get('state') == 'DISCOVERY') {
                    this.processOptOut();
                } else {
                    this.$el.find("#hipchat-glance-config-inner").removeClass("checked");
                    JIRA.trace("ajax.request.completed.GlanceConfigOptOut");
                }
            }
        }
    });

    return GlanceConfigView;
});