(function (
        $,
        GlanceConfigModel,
        GlanceConfigView
) {
    function init() {

        var $glanceConfiguration = $("#hipchat-glance-config");
        if ($glanceConfiguration) {
            window.onbeforeunload = null;
        }
        var $glanceConfigurationInner = $("#hipchat-glance-config-inner");
        var glanceConfigModel = new GlanceConfigModel({
            roomId: $glanceConfigurationInner.data("room-id"),
            state: $glanceConfigurationInner.data("state"),
            jql: $glanceConfigurationInner.data("jql"),
            name: $glanceConfigurationInner.data("name"),
            jiraUser: $glanceConfigurationInner.data("jira-user"),
            loginLink: $glanceConfigurationInner.data("login-link"),
            jwtToken: $glanceConfigurationInner.data("jwt-token"),
            editing: false
        });
        var glanceConfigView = new GlanceConfigView({
            model: glanceConfigModel,
            el: $glanceConfiguration
        });
        glanceConfigView.render();
    }

    $(function() {
        init();
    });
})(
        require("jquery"),
        require("hipchat/feature/connect/glance-config"),
        require("hipchat/feature/connect/glance-config-view")
);
