require(['jquery', 'jira/flag', 'jira/util/users/logged-in-user', 'wrm/context-path'], function ($, flag, loggedInUser, wrmContextPath) {
    var cookie = AJS.Cookie;
    AJS.toInit(function () {

        var HIPCHAT_ADMIN_BANNER_COOKIE_KEY = "HIPCHAT_ADMIN_BANNER_DISMISS_2";
        var warningMsg;

        if (!isHipChatConfigurationPage() && loggedInUser.isAdmin() && !isAlreadyDismissed()) {

            $.ajax({
                url: wrmContextPath() + '/rest/hipchat/integrations/1.0/configuration/status',
                dataType: 'json',
                cache: false
            }).done(function (data) {

                if (data.installationCheckResult.required || data.v1) {
                    warningMsg = showWarningMsg(data);
                }
            });

        }

        function showWarningMsg(data) {
            var html = JIRA.Templates.HipChat.Banner.updateHipChatLink({
                        removeV1link: !data.v2 && data.v1,
                        reinstallationDiscoveryTitle: data.installationCheckResult.discoveryTitle,
                        reinstallationDiscoveryText: data.installationCheckResult.discoveryText
                    });
            var warningMsg = flag.showWarningMsg(null, html);
            $(document).on("click", "#remove-hipchat-v1-link", removeHipChatLink);
            $(document).on("aui-flag-close", ".aui-flag", dismissPopUp);
            return warningMsg;
        }

        function isHipChatConfigurationPage() {
            return window.location.toString().indexOf("/plugins/servlet/hipchat/configure") > 0;
        }

        function dismissPopUp(e) {

            // The aui flag sends all the close events, that is why we need to filter
            // to the flag that has my container
            if ($(e.target).find(".hipchat-update-banner").length > 0) {
                cookie.save(HIPCHAT_ADMIN_BANNER_COOKIE_KEY, true);
            }
        }

        function isAlreadyDismissed() {
            return cookie.read(HIPCHAT_ADMIN_BANNER_COOKIE_KEY) == "true";
        }


        function removeHipChatLink(e) {
            e.preventDefault();

            $.ajax({
                url: wrmContextPath() + '/rest/hipchat/integrations/1.0/configuration/v1',
                cache: false,
                type: "DELETE"
            }).error(function (error) {

                if(warningMsg){
                    warningMsg.hide();
                }

                flag.showErrorMsg(null, AJS.I18n.getText("plugins.hipchat.reinstall.discovery.remove.hipchat.error", error.status));

            }).done(function (data) {

                if(warningMsg){
                    warningMsg.hide();
                }

                flag.showSuccessMsg(null, AJS.I18n.getText("plugins.hipchat.reinstall.discovery.remove.hipchat.success"));
            });
        }
    });
});
