AJS.test.require([
    "com.atlassian.jira.plugins.jira-editor-plugin:element",
    "com.atlassian.jira.plugins.jira-editor-plugin:customization"
], function() {
    require([
        "jira/editor/ui/rich-editor",
        "wrm/context-path",
        "jquery"
    ], function(
        RichEditor,
        wrmContextPath,
        $
    ) {
        module("RichEditor", {
            setup: function () {
                this.sandbox = sinon.sandbox.create({ useFakeServer: true });

                this.mockServer();
                this.mockEditor();
            },

            mockEditor: function() {
                this.$textarea = $('<textarea>some content</textarea>');
                $('#qunit-fixture').append(this.$textarea);
                this.editor = new RichEditor();
                this.editor.$textarea = this.$textarea;
                this.editor.richEditorInstance = {
                    setContent: this.sandbox.stub(),
                    show: this.sandbox.stub(),
                    hide: this.sandbox.stub(),
                    focus: this.sandbox.stub(),
                    enable: this.sandbox.stub(),
                    disable: this.sandbox.stub()
                };
            },

            mockServer: function () {
                this.sandbox.server.xhr.useFilters = true;
                this.sandbox.server.autoRespond = true;
                var fakeRequests = this.fakeRequests = [];
                this.sandbox.server.xhr.addFilter(function (method, uri) {
                    return fakeRequests.indexOf(uri) === -1;
                });
            },

            teardown: function () {
                this.sandbox.restore();
            }
        });

        asyncTest("setMode should fail when unable to render", function (done) {
            var renderUri = wrmContextPath() + "/rest/api/1.0/render";
            this.fakeRequests.push(renderUri);
            this.sandbox.server.respondWith("POST", renderUri, [501, {"Content-Type": "application/json"}, ""]);

            this.editor.setMode(false).fail(function () {
                ok(true, "setMode failed");
                start();
            }).done(function () {
                ok(false, "setMode was success");

                start();
            });
        });

        asyncTest("setMode should not fail when able to render", function (done) {
            this.editor.setMode(false).done(function () {
                ok(true, "setMode was success");
                equal(this.editor.richEditorInstance.setContent.getCall(0).args[0], "some content");

                start();
            }.bind(this));
        });

        test("coverTextarea should make $wikiTextarea not focusable", function () {
            var event = $.Event("focus");

            this.editor.coverTextarea();

            this.editor.$textarea.trigger(event);
            ok(event.isDefaultPrevented(), "Should prevent focus");
        });

        test("uncoverTextarea should make $wikiTextarea focusable", function () {
            var event = $.Event("focus");

            this.editor.coverTextarea();

            ok(!event.isDefaultPrevented(), "Should not be prevented by default");
            this.editor.$textarea.trigger(event);
            ok(event.isDefaultPrevented(), "Should prevent focus");

            this.editor.uncoverTextarea();

            event = $.Event("focus");
            this.editor.$textarea.trigger(event);
            ok(!event.isDefaultPrevented(), "Should not prevent focus");
        });
    });
});
