AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:toggle"], function() {
    var $ = require("jquery");
    var editorToggle = require("jira/editor/toggle");
    var ToggleTabs = require("jira/editor/ui/toggle-tabs");
    var Cookie = require("jira/data/cookie");
    var featureManager = require("jira/featureflags/feature-manager");
    var skate = require("atlassian/libs/skate-0.12.6");
    var _ = require("underscore");

    module("ToggleTabs", {
        setup: function () {
            this.sandbox = sinon.sandbox.create({ });
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("Should show Visual tooltip on toggle", function(done) {
        this.sandbox.stub(Cookie, "read")
            .withArgs("jira.editor.user.mode").returns("source");

        verifyToggle('wysiwyg', AJS.I18n.getText('jira.editor.toggle.mode.visual'));
    });

    test("Should show Text tooltip on toggle", function(done) {
        this.sandbox.stub(Cookie, "read")
            .withArgs("jira.editor.user.mode").returns("wysiwyg");

        verifyToggle('source', AJS.I18n.getText('jira.editor.toggle.mode.text'));
    });

    test("Should hide tooltip after 750ms", function(done) {
        this.sandbox.useFakeTimers();

        this.sandbox.stub(Cookie, "read")
            .withArgs("jira.editor.user.mode").returns("source");

        verifyToggle('wysiwyg', AJS.I18n.getText('jira.editor.toggle.mode.visual'));


        this.sandbox.clock.tick(800);

        ok($('#qunit-fixture').find('.editor-toggle-tooltip').is(':not(.visible)'));

    });

    test("Should trigger `change` event when switching from Text to Visual", function () {
        var tabs = createTabs();
        var triggerStub = this.sandbox.stub(tabs, 'trigger');
        tabs.setMode("source");

        selectMode(tabs, "wysiwyg");

        sinon.assert.calledOnce(triggerStub);
        sinon.assert.calledWithExactly(triggerStub, "change", "wysiwyg")
    });

    test("Should trigger `change` event when switching from Visual to Text", function () {
        var tabs = createTabs();
        var triggerStub = this.sandbox.stub(tabs, 'trigger');
        tabs.setMode("wysiwyg");

        selectMode(tabs, "source");

        sinon.assert.calledOnce(triggerStub);
        sinon.assert.calledWithExactly(triggerStub, "change", "source")
    });

    test("Should not trigger `change` event when switching from Visual to Visual", function () {
        var tabs = createTabs();
        var triggerStub = this.sandbox.stub(tabs, 'trigger');
        tabs.setMode("wysiwyg");

        selectMode(tabs, "wysiwyg");

        sinon.assert.notCalled(triggerStub);
    });

    test("Should not trigger `change` event when switching from Text to Text", function () {
        var tabs = createTabs();
        var triggerStub = this.sandbox.stub(tabs, 'trigger');
        tabs.setMode("source");

        selectMode(tabs, "source");

        sinon.assert.notCalled(triggerStub);
    });


    var createTabs = function() {
        var $element = $('<div class="wiki-edit-content" style="position: fixed; left: 100px; top: 100px"><textarea> </textarea></div>').appendTo('#qunit-fixture').find('textarea');
        return new ToggleTabs($element[0]);
    };

    var verifyToggle = function(mode, expectedText) {
        var tabs = createTabs();

        var $tooltip = tabs.$parent.find('.editor-toggle-tooltip');
        selectMode(tabs, mode);

        ok($tooltip.is('.visible'));
        equal($tooltip.text(), expectedText);
    }

    var selectMode = function(tabs, mode) {
        tabs.$parent.find('*[data-mode="' + mode + '"] a').click();
    }
});